<?php
/**
 * Invoice Ninja (https://invoiceninja.com).
 *
 * @link https://github.com/invoiceninja/invoiceninja source repository
 *
 * @copyright Copyright (c) 2021. Invoice Ninja LLC (https://invoiceninja.com)
 *
 * @license https://opensource.org/licenses/AAL
 */
namespace Database\Seeders;

use App\Models\Bank;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;

class BanksSeeder extends Seeder
{
    public function run()
    {
        Model::unguard();

        $this->createBanks();
    }

    // Source: http://www.ofxhome.com/
    private function createBanks()
    {
        // http://www.ofxhome.com/api.php?dump=yes
        // http://www.utilities-online.info/xmltojson
        // http://www.httputility.net/json-minifier.aspx
        $banks = '[{"id":"421","name":"ING DIRECT (Canada)","fid":"061400152","org":"INGDirectCanada","url":"https://ofx.ingdirect.ca","ofxfail":"1","sslfail":"5","lastofxvalidation":"2014-10-26 22:57:57","lastsslvalidation":"2014-12-03 23:01:03","profile":{"-addr1":"3389 Steeles Avenue East","-city":"Toronto","-state":"ON","-postalcode":"M2H 3S8","-country":"CAN","-csphone":"800-464-3473","-tsphone":"800-464-3473","-url":"http://www.tangerine.ca","-email":"clientservices@ingdirect.ca","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"422","name":"Safe Credit Union - OFX Beta","fid":"321173742","org":"DI","url":"https://ofxcert.diginsite.com/cmr/cmr.ofx","ofxfail":"3","sslfail":"0","lastofxvalidation":"2010-03-18 16:25:00","lastsslvalidation":"2015-07-02 23:46:44"},{"id":"423","name":"Ascentra Credit Union","fid":"273973456","org":"Alcoa Employees&Community CU","url":"https://alc.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-10-01 22:03:55","lastsslvalidation":"2013-10-01 22:03:55","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"424","name":"American Express Card","fid":"3101","org":"AMEX","url":"https://online.americanexpress.com/myca/ofxdl/desktop/desktopDownload.do?request_type=nl_ofxdownload","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-11-23 09:54:17","lastsslvalidation":"2015-06-22 22:09:26","profile":{"-addr1":"777 American Expressway","-city":"Fort Lauderdale","-state":"Fla.","-postalcode":"33337-0001","-country":"USA","-csphone":"1-800-AXP-7500  (1-800-297-7500)","-url":"https://online.americanexpress.com/myca/ofxdl/desktop/desktopDownload.do?request_type=nl_ofxdownload","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"425","name":"TD Ameritrade","fid":"5024","org":"ameritrade.com","brokerid":"ameritrade.com","url":"https://ofxs.ameritrade.com/cgi-bin/apps/OFX","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-11-09 23:43:48","lastsslvalidation":"2016-01-18 10:26:26","profile":{"-addr1":"4211 So. 102nd Street","-city":"Omaha","-state":"NE","-postalcode":"68127","-country":"USA","-csphone":"1-212-723-2898","-tsphone":"1-212-723-2898","-url":"https://ofxs.ameritrade.com/cgi-bin/apps/OFX","-email":"alex_shnir@smb.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true","-notes":"Username is case sensitive Automatically imports 2 years of transactions Older transactions may be imported from the Ameritrade website.  See documentation for more details. mported stock split transactions may have incorrect data"}},{"id":"426","name":"Truliant FCU","fid":"253177832","org":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-03 00:02:33","lastsslvalidation":"2015-07-03 00:02:32","profile":{"-addr1":"3200 Truliant Way","-city":"Winston-Salem","-state":"NC","-postalcode":"27103","-country":"USA","-csphone":"800-822-0382","-tsphone":"800-822-038","-url":"www.truliantfcu.org","-email":"2","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"427","name":"AT&T Universal Card","fid":"24909","org":"Citigroup","url":"https://secureofx2.bankhost.com/citi/cgi-forte/ofx_rt?servicename=ofx_rt&pagename=ofx","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-03-06 22:04:25","lastsslvalidation":"2013-06-11 22:03:53","profile":{"-addr1":"8787 Baypine Road","-city":"Jacksonville","-state":"FL","-postalcode":"32256","-country":"USA","-csphone":"1-800-950-5114","-tsphone":"1-800-347-4934","-url":"http://www.citicards.com","-signonmsgset":"true","-creditcardmsgset":"true"}},{"id":"428","name":"Bank One","fid":"5811","org":"B1","url":"https://onlineofx.chase.com/chase.ofx","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-11-15 01:32:59","lastsslvalidation":"2009-12-25 01:33:13"},{"id":"429","name":"Bank of Stockton","fid":"3901","org":"BOS","url":"https://internetbanking.bankofstockton.com/scripts/serverext.dll","ofxfail":"3","sslfail":"0","lastofxvalidation":"2011-06-16 22:03:30","lastsslvalidation":"2016-01-21 23:33:41"},{"id":"430","name":"Bank of the Cascades","fid":"4751","org":"JackHenry","url":"https://directline.netteller.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-21 16:10:03","lastsslvalidation":"2015-07-02 22:22:53","profile":{"-addr1":"PO Box 369","-addr2":"Bend, OR 97709","-city":"BEND","-state":"OR","-postalcode":"977010000","-country":"USA","-csphone":"(877) 617-3400","-tsphone":"1-877-617-3400","-url":"https://www.botc.com","-email":"Cust_Srv_Speclst@botc.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"431","name":"Centra Credit Union","fid":"274972883","org":"Centra CU","url":"https://centralink.org/scripts/isaofx.dll","ofxfail":"0","sslfail":"4","lastofxvalidation":"2016-01-22 13:04:46","lastsslvalidation":"2009-12-23 01:42:12","profile":{"-addr1":"1430 National Road","-city":"Columbus","-state":"IN","-postalcode":"47201","-country":"USA","-csphone":"800-232-3642","-tsphone":"800-232-3642","-url":"http://www.centra.org","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true"}},{"id":"432","name":"Centura Bank","fid":"1901","org":"Centura Bank","url":"https://www.oasis.cfree.com/1901.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:28:40","lastsslvalidation":"2015-07-02 22:28:39"},{"id":"433","name":"Charles Schwab&Co., INC","fid":"5104","org":"ISC","brokerid":"SCHWAB.COM","url":"https://ofx.schwab.com/cgi_dev/ofx_server","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-21 23:31:23","lastsslvalidation":"2016-01-21 23:33:44","profile":{"-addr1":"101 Montgomery Street","-city":"San Francisco","-state":"CA","-postalcode":"94104","-country":"USA","-csphone":"1-212-723-2898","-tsphone":"1-212-723-2898","-url":"WWW.SCHWAB.COM","-email":"alex_shnir@smb.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"434","name":"JPMorgan Chase Bank (Texas)","fid":"5301","org":"Chase Bank of Texas","url":"https://www.oasis.cfree.com/5301.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-06 05:50:49","lastsslvalidation":"2016-01-06 06:21:14"},{"id":"435","name":"JPMorgan Chase Bank","fid":"1601","org":"Chase Bank","url":"https://www.oasis.cfree.com/1601.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-06 05:50:57","lastsslvalidation":"2016-01-06 06:21:21"},{"id":"436","name":"Colonial Bank","fid":"1046","org":"Colonial Banc Group","url":"https://www.oasis.cfree.com/1046.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:33:57","lastsslvalidation":"2015-07-02 22:33:57"},{"id":"437","name":"Comerica Bank","fid":"5601","org":"Comerica","url":"https://www.oasis.cfree.com/5601.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:35:33","lastsslvalidation":"2015-07-02 22:35:33"},{"id":"438","name":"Commerce Bank NJ, PA, NY&DE","fid":"1001","org":"CommerceBank","url":"https://www.commerceonlinebanking.com/scripts/serverext.dll","ofxfail":"3","sslfail":"4","lastofxvalidation":"2009-09-24 01:33:33","lastsslvalidation":"2011-10-19 22:06:01","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"439","name":"Commerce Bank, NA","fid":"4001","org":"Commerce Bank NA","url":"https://www.oasis.cfree.com/4001.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:35:36","lastsslvalidation":"2015-07-02 22:35:36"},{"id":"440","name":"Commercial Federal Bank","fid":"4801","org":"CommercialFederalBank","url":"https://www.oasis.cfree.com/4801.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:35:37","lastsslvalidation":"2015-07-02 22:35:37"},{"id":"441","name":"COMSTAR FCU","fid":"255074988","org":"Comstar Federal Credit Union","url":"https://pcu.comstarfcu.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-04-10 22:16:52","lastsslvalidation":"2014-11-18 22:25:19","profile":{"-addr1":"22601-A Gateway Center Drive","-city":"Clarksburg","-state":"MD","-postalcode":"20871","-country":"USA","-csphone":"855-436-4100","-tsphone":"855-436-4100","-url":"http://www.comstarfcu.org/","-email":"mail@comstarfcu.org","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"442","name":"SunTrust","fid":"2801","org":"SunTrust PC Banking","url":"https://www.oasis.cfree.com/2801.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-19 17:26:05","lastsslvalidation":"2015-11-13 03:34:23"},{"id":"443","name":"Denali Alaskan FCU","fid":"1","org":"Denali Alaskan FCU","url":"https://remotebanking.denalifcu.com/ofx/ofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-11-19 22:11:59","lastsslvalidation":"2014-05-06 22:20:31","profile":{"-addr1":"P.O. BOX 2351","-city":"Sacramento","-state":"CA","-postalcode":"95812","-country":"USA","-csphone":"916 444 6070","-url":"https://homebank.sactocu.org","-email":"info@sactocu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"444","name":"Discover Card","fid":"7101","org":"Discover Financial Services","url":"https://ofx.discovercard.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-22 05:58:34","lastsslvalidation":"2016-01-22 21:54:39","profile":{"-addr1":"2500 Lake Cook Road","-city":"Riverwoods","-state":"IL","-postalcode":"60015","-country":"USA","-csphone":"1-800-DISCOVER","-tsphone":"1-800-DISCOVER","-url":"https://www.discover.com","-email":"websupport@service.discovercard.com","-signonmsgset":"true","-creditcardmsgset":"true"}},{"id":"445","name":"Dreyfus","org":"DST","brokerid":"www.dreyfus.com","url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=703170424052018","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-25 03:21:42","lastsslvalidation":"2016-01-22 21:54:40","profile":{"-addr1":"P.O. Box 173375","-city":"Denver","-state":"CO","-postalcode":"80217","-country":"USA","-csphone":"816.345.7645","-tsphone":"816.345.7645","-url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=50900132018","-email":"service@americancentury.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"446","name":"E*TRADE","fid":"fldProv_mProvBankId","org":"fldProv_mId","brokerid":"etrade.com","url":"https://ofx.etrade.com/cgi-ofx/etradeofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-12-26 08:06:15","lastsslvalidation":"2015-11-23 04:34:34","profile":{"-addr1":"4500 Bohannon Drive","-city":"Menlo Park","-state":"CA","-postalcode":"94025","-country":"USA","-csphone":"1-800-786-2575","-tsphone":"1-800-786-2575","-url":"http://www.etrade.com","-email":"service@etrade.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"447","name":"Eastern Bank","fid":"6201","org":"Eastern Bank","url":"https://www.oasis.cfree.com/6201.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:49:39","lastsslvalidation":"2015-07-02 22:49:38"},{"id":"448","name":"EDS Credit Union","fid":"311079474","org":"EDS CU","url":"https://eds.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 01:47:08","lastsslvalidation":"2009-12-23 01:47:07"},{"id":"449","name":"Fidelity Investments","fid":"7776","org":"fidelity.com","brokerid":"fidelity.com","url":"https://ofx.fidelity.com/ftgw/OFX/clients/download","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:54:46","lastsslvalidation":"2015-07-02 22:54:45","profile":{"-addr1":"Fidelity Brokerage Services, Inc","-addr2":"82 Devonshire Street","-city":"Boston","-state":"MA","-postalcode":"2109","-country":"USA","-csphone":"1-800-544-7931","-url":"http://www.fidelity.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true","-notes":"Set username to your fidelity Customer ID Automatically imports 3 months of transactions"}},{"id":"450","name":"Fifth Third Bancorp","fid":"5829","org":"Fifth Third Bank","url":"https://banking.53.com/ofx/OFXServlet","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-20 09:56:15","lastsslvalidation":"2016-01-05 16:20:43","profile":{"-addr1":"Madisonville Operations Center","-addr2":"MD 1MOC3A","-city":"Cincinnati","-state":"OH","-postalcode":"45263","-country":"USA","-csphone":"800-972-3030","-url":"http://www.53.com/","-email":"53_GeneralInquiries@53.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"451","name":"First Tech Credit Union","fid":"2243","org":"First Tech Credit Union","url":"https://ofx.firsttechcu.com","ofxfail":"1","sslfail":"5","lastofxvalidation":"2011-07-10 22:09:25","lastsslvalidation":"2011-07-10 22:09:24"},{"id":"452","name":"zWachovia","fid":"4301","org":"Wachovia","url":"https://www.oasis.cfree.com/4301.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-19 15:16:07","lastsslvalidation":"2016-01-18 07:16:02"},{"id":"453","name":"KeyBank","fid":"5901","org":"KeyBank","url":"https://www.oasis.cfree.com/fip/genesis/prod/05901.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-06 05:52:02","lastsslvalidation":"2016-01-06 06:22:22","profile":{"-addr1":"333 North Summit Street","-addr2":"11th Floor","-city":"Toledo","-state":"OH","-postalcode":"43604","-country":"USA","-url":"http://www.keybank.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"454","name":"Mellon Bank","fid":"1226","org":"Mellon Bank","url":"https://www.oasis.cfree.com/1226.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-09 18:45:11","lastsslvalidation":"2016-01-17 18:55:14"},{"id":"455","name":"LaSalle Bank Midwest","fid":"1101","org":"LaSalleBankMidwest","url":"https://www.oasis.cfree.com/1101.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-12 00:21:16","lastsslvalidation":"2016-01-15 10:20:33"},{"id":"456","name":"Nantucket Bank","fid":"466","org":"Nantucket","url":"https://ofx.onlinencr.com/scripts/serverext.dll","ofxfail":"2","sslfail":"0","lastofxvalidation":"2014-03-08 22:45:11","lastsslvalidation":"2015-07-02 23:26:36","profile":{"-addr1":"104 Pleasant Street","-city":"Nantucket","-state":"MA","-postalcode":"02554","-country":"USA","-csphone":"1-800-533-9313","-tsphone":"1-800-533-9313","-url":"http://www.nantucketbank.com/","-email":"callcenter@nantucketbank.com","-signonmsgset":"true","-bankmsgset":"true","-emailmsgset":"true"}},{"id":"457","name":"National Penn Bank","fid":"6301","org":"National Penn Bank","url":"https://www.oasis.cfree.com/6301.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-23 22:19:27","lastsslvalidation":"2016-01-18 16:15:24"},{"id":"458","name":"Nevada State Bank - New","fid":"1121","org":"295-3","url":"https://quicken.metavante.com/ofx/OFXServlet","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:28:22","lastsslvalidation":"2015-07-02 23:28:22","profile":{"-addr1":"PO Box 990","-city":"Las Vegas","-state":"NV","-postalcode":"89125-0990","-country":"USA","-csphone":"1-888-835-0551","-tsphone":"1-888-835-0551","-url":"http://nsbank.com/contact/index.jsp","-email":"nsbankpfm@nsbank.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-interxfermsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"459","name":"UBS Financial Services Inc.","fid":"7772","org":"Intuit","brokerid":"ubs.com","url":"https://ofx1.ubs.com/eftxweb/access.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-19 00:43:02","lastsslvalidation":"2015-12-26 20:28:02","profile":{"-addr1":"1285 Avenue of the Americas","-city":"New York","-state":"NY","-postalcode":"10011","-country":"USA","-csphone":"1-888-279-3343","-tsphone":"1-888-279-3343","-url":"http://financialservicesinc.ubs.com","-email":"OnlineService@ubs.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"460","name":"Patelco CU","fid":"2000","org":"Patelco Credit Union","url":"https://ofx.patelco.org","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:33:47","lastsslvalidation":"2015-07-02 23:33:45","profile":{"-addr1":"156 Second Street","-city":"San Francisco","-state":"CA","-postalcode":"94105","-country":"USA","-csphone":"415-442-6200","-tsphone":"800-358-8228","-url":"http://www.patelco.org","-email":"patelco@patelco.org","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"461","name":"Mercantile Brokerage Services","fid":"011","org":"Mercantile Brokerage","brokerid":"mercbrokerage.com","url":"https://ofx.netxclient.com/cgi/OFXNetx","ofxfail":"3","sslfail":"0","lastofxvalidation":"2014-03-18 22:41:57","lastsslvalidation":"2015-07-02 23:21:28","profile":{"-addr1":"620 Liberty Avenue","-city":"Pittsburgh","-state":"PA","-postalcode":"15222","-country":"USA","-csphone":"1-800-762-6111","-tsphone":"-","-url":"http://www.pnc.com","-email":"Michael.ley@pnc.com","-signonmsgset":"true","-invstmtmsgset":"true"}},{"id":"462","name":"Regions Bank","fid":"243","org":"regions.com","brokerid":"regions.com","url":"https://ofx.morgankeegan.com/begasp/directtocore.asp","ofxfail":"1","sslfail":"5","lastofxvalidation":"2014-03-21 22:53:29","lastsslvalidation":"2014-07-16 22:38:01"},{"id":"463","name":"Spectrum Connect/Reich&Tang","fid":"6510","org":"SpectrumConnect","url":"https://www.oasis.cfree.com/6510.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-17 14:16:29","lastsslvalidation":"2016-01-09 17:21:13"},{"id":"464","name":"Smith Barney - Transactions","fid":"3201","org":"SmithBarney","url":"https://www.oasis.cfree.com/3201.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-11-27 14:23:03","lastsslvalidation":"2015-12-18 20:37:25"},{"id":"465","name":"Southwest Airlines FCU","fid":"311090673","org":"Southwest Airlines EFCU","url":"https://www.swacuflashbp.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 02:05:45","lastsslvalidation":"2009-12-23 02:05:44"},{"id":"466","name":"T. Rowe Price","org":"T. Rowe Price","brokerid":"troweprice.com","url":"https://www3.troweprice.com/ffs/ffsweb/OFXServlet","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-11-11 07:15:01","lastsslvalidation":"2015-11-02 02:19:28","profile":{"-addr1":"P.O. Box 173375","-city":"Denver","-state":"CO","-postalcode":"80217","-country":"USA","-csphone":"816.345.7645","-tsphone":"816.345.7645","-url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=50900132018","-email":"service@americancentury.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"467","name":"Technology Credit Union - CA","fid":"11257","org":"Tech CU","url":"https://webbranchofx.techcu.com/TekPortalOFX/servlet/TP_OFX_Controller","ofxfail":"1","sslfail":"5","lastofxvalidation":"2014-10-06 23:37:39","lastsslvalidation":"2014-10-06 23:37:38","profile":{"-addr1":"2010 North First Street","-addr2":"PO Box 1409","-city":"San Jose","-state":"CA","-postalcode":"95109-1409","-country":"USA","-csphone":"800-553-0880","-tsphone":"800-553-0880","-url":"http://www.techcu.com/","-email":"support@tekbank.com","-signonmsgset":"true","-bankmsgset":"true","-emailmsgset":"true"}},{"id":"468","name":"UMB Bank","fid":"0","org":"UMB","url":"https://pcbanking.umb.com/hs_ofx/hsofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2008-10-08 01:35:42","lastsslvalidation":"2008-10-08 01:35:41"},{"id":"469","name":"Union Bank of California","fid":"2901","org":"Union Bank of California","url":"https://www.oasis.cfree.com/2901.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-12 16:02:13","lastsslvalidation":"2015-12-20 10:16:13"},{"id":"470","name":"United Teletech Financial","fid":"221276011","org":"DI","url":"https://ofxcore.digitalinsight.com:443/servlet/OFXCoreServlet","ofxfail":"1","sslfail":"5","lastofxvalidation":"2008-12-16 01:50:18","lastsslvalidation":"2008-12-16 01:50:17"},{"id":"471","name":"US Bank","fid":"1401","org":"US Bank","url":"https://www.oasis.cfree.com/1401.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-12-16 08:58:47","lastsslvalidation":"2015-11-05 15:17:49"},{"id":"472","name":"Bank of America (All except CA, WA,&ID)","fid":"6812","org":"HAN","url":"https://ofx.bankofamerica.com/cgi-forte/fortecgi?servicename=ofx_2-3&pagename=ofx","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-05-03 22:15:29","lastsslvalidation":"2015-05-03 22:15:29","profile":{"-addr1":"Interactive Banking","-addr2":"TX1-854-06-12","-addr3":"P.O. Box 655961","-city":"Dallas","-state":"TX","-postalcode":"75265-9964","-country":"USA","-csphone":"(800) 933-6262","-tsphone":"(800) 933-6262","-url":"http://www.bankofamerica.com","-email":"forte@bankofamerica.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"473","name":"Wells Fargo","fid":"3000","org":"WF","url":"https://ofxdc.wellsfargo.com/ofx/process.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-22 21:50:51","lastsslvalidation":"2016-01-22 21:54:43","profile":{"-addr1":"P.O. Box 6808","-city":"Concord","-state":"CA","-postalcode":"94524","-country":"USA","-csphone":"1-800-956-4442","-tsphone":"1-800-956-4442","-url":"https://online.wellsfargo.com/","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"474","name":"LaSalle Bank NA","fid":"6501","org":"LaSalle Bank NA","url":"https://www.oasis.cfree.com/6501.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-25 23:34:46","lastsslvalidation":"2015-07-02 23:19:34"},{"id":"475","name":"BB&T","fid":"BB&T","org":"BB&T","url":"https://eftx.bbt.com/eftxweb/access.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-24 12:00:31","lastsslvalidation":"2015-07-02 22:26:12"},{"id":"476","name":"Los Alamos National Bank","fid":"107001012","org":"LANB","url":"https://ofx.lanb.com/ofx/ofxrelay.dll","ofxfail":"0","sslfail":"4","lastofxvalidation":"2015-12-27 16:33:26","lastsslvalidation":"2014-02-13 22:39:37","profile":{"-addr1":"1200 Trinity Drive","-city":"Los Alamos","-state":"NM","-postalcode":"87544","-country":"USA","-csphone":"5056625171","-tsphone":"5056620239","-url":"WWW.LANB.COM","-email":"lanb@lanb.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"477","name":"Citadel FCU","fid":"citadel","org":"CitadelFCU","url":"https://pcu.citadelfcu.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2011-09-12 22:05:43","lastsslvalidation":"2014-10-23 22:21:26","profile":{"-addr1":"3030 Zinn Road","-city":"Thorndale","-state":"PA","-postalcode":"19372","-country":"USA","-csphone":"610-380-6000","-tsphone":"610-380-6000","-url":"https://www.citadelfcu.org","-email":"info@citadelfcu.org","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"478","name":"Clearview Federal Credit Union","fid":"243083237","org":"Clearview Federal Credit Union","url":"https://www.pcu.clearviewfcu.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 01:42:29","lastsslvalidation":"2009-12-23 01:42:28"},{"id":"479","name":"Vanguard Group, The","fid":"1358","org":"The Vanguard Group","brokerid":"vanguard.com","url":"https://vesnc.vanguard.com/us/OfxDirectConnectServlet","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-25 00:09:30","lastsslvalidation":"2015-10-25 04:03:04","profile":{"-addr1":"P.O. Box 1110","-city":"Valley Forge","-state":"PA","-postalcode":"19482-1110","-country":"USA","-csphone":"1-212-723-2898","-tsphone":"1-212-723-2898","-url":"https://vesnc.vanguard.com/us/OfxDirectConnectServlet","-email":"alex_shnir@smb.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-emailmsgset":"true","-seclistmsgset":"true"}},{"id":"480","name":"First Citizens Bank - NC, VA, WV","fid":"5013","org":"First Citizens Bank NC, VA, WV","url":"https://www.oasis.cfree.com/5013.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:58:01","lastsslvalidation":"2015-07-02 22:58:01"},{"id":"481","name":"Northern Trust - Banking","fid":"5804","org":"ORG","url":"https://www3883.ntrs.com/nta/ofxservlet","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-03-14 22:33:34","lastsslvalidation":"2015-03-26 23:22:06","profile":{"-addr1":"50 South LaSalle Street","-city":"Chicago","-state":"IL","-postalcode":"60675","-country":"USA","-csphone":"888-635-5350","-tsphone":"888-635-5350","-url":"https://web-xp1-ofx.ntrs.com/ofx/ofxservlet","-email":"www.northerntrust.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"482","name":"The Mechanics Bank","fid":"121102036","org":"TMB","url":"https://ofx.mechbank.com/OFXServer/ofxsrvr.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2011-04-25 22:21:40","lastsslvalidation":"2011-04-25 22:21:40"},{"id":"483","name":"USAA Federal Savings Bank","fid":"24591","org":"USAA","url":"https://service2.usaa.com/ofx/OFXServlet","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-06 23:02:04","lastsslvalidation":"2016-01-06 23:05:03","profile":{"-addr1":"10750 McDermott Freeway","-city":"San Antonio","-state":"TX","-postalcode":"78288","-country":"USA","-csphone":"877-820-8320","-tsphone":"877-820-8320","-url":"www.usaa.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"484","name":"Florida Telco CU","fid":"FTCU","org":"FloridaTelcoCU","url":"https://ppc.floridatelco.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2011-09-06 22:15:02","lastsslvalidation":"2009-12-23 01:47:48","profile":{"-addr1":"9700 Touchton Rd","-city":"Jacksonville","-state":"FL","-postalcode":"32246","-country":"USA","-csphone":"904-723-6300","-tsphone":"904-723-6300","-url":"https://121fcu.org","-email":"webmaster@121fcu.org","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"485","name":"DuPont Community Credit Union","fid":"251483311","org":"DuPont Community Credit Union","url":"https://pcu.mydccu.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-11-17 01:42:26","lastsslvalidation":"2009-12-23 01:46:53"},{"id":"486","name":"Central Florida Educators FCU","fid":"590678236","org":"CentralFloridaEduc","url":"https://www.mattweb.cfefcu.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-02-18 22:08:38","lastsslvalidation":"2012-03-19 22:05:30","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"487","name":"California Bank&Trust","fid":"5006","org":"401","url":"https://pfm.metavante.com/ofx/OFXServlet","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-21 00:31:08","lastsslvalidation":"2015-07-02 22:28:05","profile":{"-addr1":"9775 Claremont Mesa Blvd","-city":"San Diego","-state":"CA","-postalcode":"92124","-country":"USA","-csphone":"888-217-1265","-tsphone":"888-217-1265","-url":"www.calbanktrust.com","-email":"cbtquestions@calbt.com","-signonmsgset":"true","-bankmsgset":"true","-interxfermsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"488","name":"First Commonwealth FCU","fid":"231379199","org":"FirstCommonwealthFCU","url":"https://pcu.firstcomcu.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-05-31 22:27:02","lastsslvalidation":"2013-10-07 22:14:50","profile":{"-addr1":"P.O. Box 20450","-city":"Lehigh Valley","-state":"PA","-postalcode":"18002","-country":"USA","-csphone":"610-821-2403","-tsphone":"610-821-2403","-url":"https://www.firstcomcu.org","-email":"memserv@firstcomcu.org","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"489","name":"Ameriprise Financial Services, Inc.","fid":"3102","org":"AMPF","brokerid":"ameriprise.com","url":"https://www25.ameriprise.com/AMPFWeb/ofxdl/us/download?request_type=nl_desktopdownload","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:16:05","lastsslvalidation":"2016-01-21 08:00:06","profile":{"-addr1":"70400 Ameriprise Financial Ctr.","-city":"Minneapolis","-state":"MN","-postalcode":"55474","-country":"USA","-csphone":"1-800-297-8800","-tsphone":"1-800-297-SERV","-url":"http://www.ameriprise.com","-email":"broker@ampf.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"490","name":"AltaOne Federal Credit Union","fid":"322274462","org":"AltaOneFCU","url":"https://pcu.altaone.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-09-10 01:32:25","lastsslvalidation":"2009-12-25 01:32:52","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true"}},{"id":"491","name":"A. G. Edwards and Sons, Inc.","fid":"43-0895447","org":"A.G. Edwards","brokerid":"agedwards.com","url":"https://ofx.agedwards.com","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-05-01 01:30:10","lastsslvalidation":"2009-05-01 01:30:10"},{"id":"492","name":"Educational Employees CU Fresno","fid":"321172594","org":"Educational Employees C U","url":"https://www.eecuonline.org/scripts/isaofx.dll","ofxfail":"3","sslfail":"0","lastofxvalidation":"2011-08-21 01:18:02","lastsslvalidation":"2015-11-20 21:23:53","profile":{"-addr1":"2222 West Shaw","-city":"Fresno","-state":"CA","-postalcode":"93711","-country":"USA","-csphone":"1-800-538-3328","-tsphone":"1-800-538-3328","-url":"http://www.eecufresno.org","-email":"onlineaccesss@eecufresno.org","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"493","name":"Hawthorne Credit Union","fid":"271979193","org":"Hawthorne Credit Union","url":"https://hwt.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-08-15 22:22:55","lastsslvalidation":"2013-08-15 22:22:55","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"494","name":"Firstar","fid":"1255","org":"Firstar","url":"https://www.oasis.cfree.com/1255.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:05:30","lastsslvalidation":"2015-07-02 23:05:30"},{"id":"495","name":"myStreetscape","fid":"7784","org":"Fidelity","brokerid":"1234","url":"https://ofx.ibgstreetscape.com:443","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:26:35","lastsslvalidation":"2016-01-12 13:35:24","profile":{"-addr1":"XXXXXXXXXX","-city":"XXXXXXXXXX","-state":"XX","-postalcode":"XXXXX","-country":"USA","-csphone":"Contact your broker/dealer.","-tsphone":"Contact your broker/dealer.","-url":"https://ofx.ibgstreetscape.com","-signonmsgset":"true","-invstmtmsgset":"true"}},{"id":"496","name":"Collegedale Credit Union","fid":"35GFA","org":"CollegedaleCU","url":"https://www.netit.financial-net.com/ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:33:56","lastsslvalidation":"2015-07-02 22:33:55","profile":{"-addr1":"5046 FLEMING PLAZA","-city":"COLLEGEDALE","-state":"TN","-postalcode":"37315","-country":"US","-url":"https://www.netit.financial-net.com/collegedale","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"497","name":"AIM Investments","brokerid":"dstsystems.com","url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=3000812","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:04:20","lastsslvalidation":"2016-01-24 17:44:16","profile":{"-addr1":"P.O. Box 173375","-city":"Denver","-state":"CO","-postalcode":"80217","-country":"USA","-csphone":"816.345.7645","-tsphone":"816.345.7645","-url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=50900132018","-email":"service@americancentury.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"498","name":"GCS Federal Credit Union","fid":"281076853","org":"Granite City Steel cu","url":"https://pcu.mygcscu.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-04-10 22:15:02","lastsslvalidation":"2012-04-10 22:15:02","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true"}},{"id":"499","name":"Vantage Credit Union","fid":"281081479","org":"EECU-St. Louis","url":"https://secure2.eecu.com/scripts/isaofx.dll","ofxfail":"0","sslfail":"5","lastofxvalidation":"2015-07-03 00:09:38","lastsslvalidation":"2014-10-20 23:50:11","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"500","name":"Morgan Stanley ClientServ","fid":"1235","org":"msdw.com","brokerid":"msdw.com","url":"https://ofx.morganstanleyclientserv.com/ofx/ProfileMSMoney.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-13 04:13:42","lastsslvalidation":"2015-07-02 23:23:18","profile":{"-addr1":"1 New York Plaza","-addr2":"11th Floor","-city":"New York","-state":"NY","-postalcode":"10004","-country":"USA","-csphone":"(800) 531-1596","-tsphone":"(800) 531-1596","-url":"www.morganstanleyclientserv.com","-email":"clientservfeedback@morganstanley","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"501","name":"Kennedy Space Center FCU","fid":"263179532","org":"Kennedy Space Center FCU","url":"https://www.pcu.kscfcu.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-12-19 22:35:41","lastsslvalidation":"2013-12-19 22:35:40","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"502","name":"Sierra Central Credit Union","fid":"321174770","org":"Sierra Central Credit Union","url":"https://www.sierracpu.com/scripts/isaofx.dll","ofxfail":"0","sslfail":"4","lastofxvalidation":"2016-01-18 19:40:37","lastsslvalidation":"2009-03-16 01:36:11","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"503","name":"Virginia Educators Credit Union","fid":"251481355","org":"Virginia Educators CU","url":"https://www.vecumoneylink.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2011-09-29 22:30:05","lastsslvalidation":"2011-09-29 22:30:05","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"504","name":"Red Crown Federal Credit Union","fid":"303986148","org":"Red Crown FCU","url":"https://cre.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 01:57:55","lastsslvalidation":"2009-12-23 01:57:54"},{"id":"505","name":"B-M S Federal Credit Union","fid":"221277007","org":"B-M S Federal Credit Union","url":"https://bms.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-25 01:33:03","lastsslvalidation":"2013-10-01 22:04:57"},{"id":"506","name":"Fort Stewart GeorgiaFCU","fid":"261271364","org":"Fort Stewart FCU","url":"https://fsg.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2011-07-31 22:11:12","lastsslvalidation":"2011-08-30 03:21:07"},{"id":"507","name":"Northern Trust - Investments","fid":"6028","org":"Northern Trust Investments","brokerid":"northerntrust.com","url":"https://www3883.ntrs.com/nta/ofxservlet?accounttypegroup=INV","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-03-14 22:33:38","lastsslvalidation":"2015-03-26 23:22:09","profile":{"-addr1":"50 South LaSalle Street","-city":"Chicago","-state":"IL","-postalcode":"60675","-country":"USA","-csphone":"888-635-5350","-tsphone":"888-635-5350","-url":"https://web-xp1-ofx.ntrs.com/ofx/ofxservlet","-email":"www.northerntrust.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"508","name":"Picatinny Federal Credit Union","fid":"221275216","org":"Picatinny Federal Credit Union","url":"https://banking.picacreditunion.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-07-02 23:38:40","lastsslvalidation":"2009-12-23 01:57:48","profile":{"-addr1":"100 Mineral Springs Drive","-city":"Dover","-state":"NJ","-postalcode":"07801","-country":"USA","-csphone":"973-361-5225","-tsphone":"973-361-5225","-url":"http://www.picacreditunion.com","-email":"homebanking@picacreditunion.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"509","name":"SAC FEDERAL CREDIT UNION","fid":"091901480","org":"SAC Federal CU","url":"https://pcu.sacfcu.com/scripts/isaofx.dll","ofxfail":"3","sslfail":"4","lastofxvalidation":"2009-11-16 01:56:03","lastsslvalidation":"2009-11-16 01:56:02"},{"id":"510","name":"Merrill Lynch&Co., Inc.","fid":"5550","org":"Merrill Lynch & Co., Inc.","brokerid":"www.mldirect.ml.com","url":"https://taxcert.mlol.ml.com/eftxweb/access.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-16 01:08:32","lastsslvalidation":"2016-01-24 17:44:22","profile":{"-addr1":"55 Broad Street","-addr2":"2nd Floor","-city":"New York","-state":"NY","-postalcode":"10004","-country":"USA","-csphone":"212 344 2000","-tsphone":"212 344 2000","-url":"www.joineei.com","-email":"support@joineei.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"511","name":"Southeastern CU","fid":"261271500","org":"Southeastern FCU","url":"https://moo.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 02:05:44","lastsslvalidation":"2009-12-23 02:05:43"},{"id":"512","name":"Texas Dow Employees Credit Union","fid":"313185515","org":"TexasDow","url":"https://allthetime.tdecu.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-09-22 17:23:17","lastsslvalidation":"2015-09-17 03:08:13","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"513","name":"University Federal Credit Union","fid":"314977405","org":"Univerisity FCU","url":"https://OnDemand.ufcu.org/scripts/isaofx.dll","ofxfail":"3","sslfail":"0","lastofxvalidation":"2009-05-08 01:45:24","lastsslvalidation":"2015-07-03 00:09:20"},{"id":"514","name":"Yakima Valley Credit Union","fid":"325183796","org":"Yakima Valley Credit Union","url":"https://secure1.yvcu.org/scripts/isaofx.dll","ofxfail":"2","sslfail":"4","lastofxvalidation":"2009-11-16 02:01:24","lastsslvalidation":"2011-10-03 22:29:53"},{"id":"515","name":"First Community FCU","fid":"272483633","org":"FirstCommunityFCU","url":"https://pcu.1stcomm.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2011-12-01 22:14:20","lastsslvalidation":"2012-03-06 22:14:29","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"516","name":"Wells Fargo Advisor","fid":"1030","org":"strong.com","brokerid":"strong.com","url":"https://ofx.wellsfargoadvantagefunds.com/eftxWeb/Access.ofx","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-01-26 22:29:39","lastsslvalidation":"2013-01-26 22:51:03","profile":{"-addr1":"100 Heritage Reserve","-city":"Menomonee Falls","-state":"WI","-postalcode":"53051","-country":"USA","-csphone":"1-800-359-3379","-tsphone":"1-800-359-3379","-url":"www.wellsfargoadvantagefunds.com","-email":"fundservice@wellsfargo.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"517","name":"Chicago Patrolmens FCU","fid":"271078146","org":"Chicago Patrolmens CU","url":"https://chp.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-07-29 22:04:53","lastsslvalidation":"2012-07-29 22:04:53","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"518","name":"Signal Financial Federal Credit Union","fid":"255075495","org":"Washington Telephone FCU","url":"https://webpb.sfonline.org/scripts/isaofx.dll","ofxfail":"3","sslfail":"4","lastofxvalidation":"2009-12-23 02:05:39","lastsslvalidation":"2011-03-31 22:17:19"},{"id":"519","name":"Dupaco Community Credit Union","org":"Dupaco Community Credit Union","url":"https://dupaconnect.dupaco.com/ofx/ofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 01:46:52","lastsslvalidation":"2009-12-23 01:46:50","profile":{"-addr1":"P.O. Box 173375","-city":"Denver","-state":"CO","-postalcode":"80217","-country":"USA","-csphone":"816.345.7645","-tsphone":"816.345.7645","-url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=50900132018","-email":"service@americancentury.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"520","name":"Bank-Fund Staff FCU","fid":"2","org":"Bank Fund Staff FCU","url":"https://secure.bfsfcu.org/ofx/ofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2011-03-30 22:03:51","lastsslvalidation":"2011-03-30 22:03:50"},{"id":"521","name":"APCO EMPLOYEES CREDIT UNION","fid":"262087609","org":"APCO Employees Credit Union","url":"https://apc.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-08-14 22:03:11","lastsslvalidation":"2013-08-14 22:03:10","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"522","name":"Bank of Tampa, The","fid":"063108680","org":"BOT","url":"https://OFX.Bankoftampa.com/OFXServer/ofxsrvr.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:22:53","lastsslvalidation":"2015-07-02 22:22:52","profile":{"-addr1":"4503 Woodland Corporate Blvd Suite 100","-city":"Tampa","-state":"FL","-postalcode":"33614","-country":"USA","-csphone":"813-872-1282","-url":"www.bankoftampa.com","-email":"ebanking@bankoftampa.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"523","name":"Cedar Point Federal Credit Union","fid":"255077736","org":"Cedar Point Federal Credit Union","url":"https://pcu.cpfcu.com/scripts/isaofx.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-09 04:26:34","lastsslvalidation":"2015-07-02 22:28:33","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"524","name":"Las Colinas FCU","fid":"311080573","org":"Las Colinas Federal CU","url":"https://las.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-07-01 23:34:50","lastsslvalidation":"2013-10-01 22:25:41","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"525","name":"McCoy Federal Credit Union","fid":"263179956","org":"McCoy Federal Credit Union","url":"https://www.mccoydirect.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 01:49:22","lastsslvalidation":"2009-12-23 01:49:21"},{"id":"526","name":"Old National Bank","fid":"11638","org":"ONB","url":"https://www.ofx.oldnational.com/ofxpreprocess.asp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:33:34","lastsslvalidation":"2015-07-02 23:33:33","profile":{"-addr1":"420 Main Street","-city":"Evansville","-state":"IN","-postalcode":"47708","-country":"USA","-csphone":"800-844-1720","-tsphone":"800-844-1720","-url":"http://www.oldnational.com","-email":"eftservices@oldnational.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"527","name":"Citizens Bank - Consumer","fid":"CTZBK","org":"CheckFree OFX","url":"https://www.oasis.cfree.com/0CTZBK.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:33:53","lastsslvalidation":"2015-07-02 22:33:53"},{"id":"528","name":"Citizens Bank - Business","fid":"4639","org":"CheckFree OFX","url":"https://www.oasis.cfree.com/04639.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:33:52","lastsslvalidation":"2015-07-02 22:33:52"},{"id":"529","name":"Century Federal Credit Union","fid":"241075056","org":"CenturyFederalCU","url":"https://pcu.cenfedcu.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2014-01-20 22:45:36","lastsslvalidation":"2015-01-07 22:18:15","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"530","name":"ABNB Federal Credit Union","fid":"251481627","org":"ABNB Federal Credit Union","url":"https://cuathome.abnbfcu.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2011-10-25 22:02:10","lastsslvalidation":"2011-10-25 22:02:09","profile":{"-addr1":"830 Greenbrier Circle","-city":"Chesapeake","-state":"VA","-postalcode":"23320","-country":"USA","-csphone":"757-523-5300","-tsphone":"757-523-5300","-url":"http://www.abnbfcu.org","-email":"services@abnb.org","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"531","name":"Allegiance Credit Union","fid":"303085230","org":"Federal Employees CU","url":"https://fed.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-25 01:32:51","lastsslvalidation":"2011-08-30 03:07:31"},{"id":"532","name":"Wright Patman Congressional FCU","fid":"254074345","org":"Wright Patman Congressional FCU","url":"https://www.congressionalonline.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 02:06:54","lastsslvalidation":"2011-02-17 01:20:24"},{"id":"533","name":"America First Credit Union","fid":"54324","org":"America First Credit Union","url":"https://ofx.americafirst.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-23 21:50:58","lastsslvalidation":"2016-01-21 23:33:52","profile":{"-addr1":"PO Box 9199","-city":"Ogden","-state":"UT","-postalcode":"84409","-country":"USA","-csphone":"800.999.3961","-tsphone":"866.224.2158","-url":"http://www.americafirst.com","-email":"support@americafirst.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"534","name":"Motorola Employees Credit Union","fid":"271984311","org":"Motorola Employees CU","url":"https://mecuofx.mecunet.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-06-26 01:37:30","lastsslvalidation":"2009-06-29 01:36:05"},{"id":"535","name":"Finance Center FCU (IN)","fid":"274073876","org":"Finance Center FCU","url":"https://sec.fcfcu.com/scripts/isaofx.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-01 19:20:50","lastsslvalidation":"2015-07-02 22:54:48","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"536","name":"Fort Knox Federal Credit Union","fid":"283978425","org":"Fort Knox Federal Credit Union","url":"https://fcs1.fkfcu.org/scripts/isaofx.dll","ofxfail":"3","sslfail":"4","lastofxvalidation":"2012-09-24 22:19:21","lastsslvalidation":"2012-10-24 22:18:55","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"537","name":"Wachovia Bank","fid":"4309","org":"Wachovia","url":"https://pfmpw.wachovia.com/cgi-forte/fortecgi?servicename=ofx&pagename=PFM","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-10-02 22:43:46","lastsslvalidation":"2013-02-04 22:47:39"},{"id":"538","name":"Think Federal Credit Union","fid":"291975465","org":"IBMCU","url":"https://ofx.ibmcu.com","ofxfail":"1","sslfail":"5","lastofxvalidation":"2011-05-30 22:20:53","lastsslvalidation":"2011-05-30 22:20:50"},{"id":"539","name":"PSECU","fid":"54354","org":"Teknowledge","url":"https://ofx.psecu.com/servlet/OFXServlet","ofxfail":"1","sslfail":"5","lastofxvalidation":"2014-02-19 22:52:18","lastsslvalidation":"2014-07-07 22:36:54","profile":{"-addr1":"1 Credit Union Place","-city":"Harrisburg","-state":"PA","-postalcode":"17110","-country":"USA","-csphone":"(800) 237-7328","-tsphone":"(717) 772-2272","-url":"http://www.psecu.com","-email":"support@psecu.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"540","name":"Envision Credit Union","fid":"263182558","org":"Envision Credit Union","url":"https://pcu.envisioncu.com/scripts/isaofx.dll","ofxfail":"3","sslfail":"0","lastofxvalidation":"2012-12-11 22:16:18","lastsslvalidation":"2016-01-22 11:27:32","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"541","name":"Columbia Credit Union","fid":"323383349","org":"Columbia Credit Union","url":"https://ofx.columbiacu.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2014-03-05 22:14:48","lastsslvalidation":"2014-03-05 22:14:48","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"542","name":"1st Advantage FCU","fid":"251480563","org":"1st Advantage FCU","url":"https://members.1stadvantage.org/scripts/isaofx.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-25 01:20:38","lastsslvalidation":"2015-08-04 14:15:23","profile":{"-addr1":"12891 Jefferson Avenue","-city":"Newport News","-state":"VA","-postalcode":"23608","-country":"USA","-csphone":"757-877-2444","-tsphone":"757-877-2444","-url":"http://www.1stadvantage.org","-email":"tmcabee@1stadvantage.org","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"543","name":"Central Maine FCU","fid":"211287926","org":"Central Maine FCU","url":"https://cro.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-10-01 22:07:56","lastsslvalidation":"2013-10-01 22:07:55","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"544","name":"Kirtland Federal Credit Union","fid":"307070050","org":"Kirtland Federal Credit Union","url":"https://pcu.kirtlandfcu.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-11-05 22:24:44","lastsslvalidation":"2012-11-05 22:24:43","profile":{"-addr1":"6440 Gibson Blvd. SE","-city":"Albuquerque","-state":"NM","-postalcode":"87108","-country":"USA","-csphone":"505-254-4369","-tsphone":"505-254-4369","-url":"http://www.kirtlandfcu.org","-email":"kirtland@kirtlandfcu.org","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"545","name":"Chesterfield Federal Credit Union","fid":"251480327","org":"Chesterfield Employees FCU","url":"https://chf.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 01:42:22","lastsslvalidation":"2013-10-01 22:08:09"},{"id":"546","name":"Campus USA Credit Union","fid":"263178478","org":"Campus USA Credit Union","url":"https://que.campuscu.com/scripts/isaofx.dll","ofxfail":"0","sslfail":"5","lastofxvalidation":"2016-01-22 21:51:36","lastsslvalidation":"2011-01-29 11:15:09","profile":{"-addr1":"PO BOX 147029","-city":"Gainesville","-state":"FL","-postalcode":"32614","-country":"USA","-csphone":"352-335-9090","-tsphone":"352-335-9090","-url":"http://www.campuscu.com","-email":"info@campuscu.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"547","name":"Summit Credit Union (WI)","fid":"275979034","org":"Summit Credit Union","url":"https://branch.summitcreditunion.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-02-18 01:42:39","lastsslvalidation":"2009-05-07 01:43:13"},{"id":"548","name":"Financial Center CU","fid":"321177803","org":"Fincancial Center Credit Union","url":"https://fin.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-10-01 22:16:19","lastsslvalidation":"2013-10-01 22:16:17","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"549","name":"Hawaiian Tel Federal Credit Union","fid":"321379070","org":"Hawaiian Tel FCU","url":"https://htl.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 01:47:57","lastsslvalidation":"2012-08-15 08:13:42"},{"id":"550","name":"Addison Avenue Federal Credit Union","fid":"11288","org":"hpcu","url":"https://ofx.addisonavenue.com","ofxfail":"0","sslfail":"4","lastofxvalidation":"2015-07-02 22:04:16","lastsslvalidation":"2011-05-26 22:02:25","profile":{"-addr1":"3408 Hillview Ave","-city":"Palo Alto","-state":"CA","-postalcode":"94304","-country":"USA","-csphone":"877.233.4766","-tsphone":"877.233.4766","-url":"http://www.addisonavenue.com","-email":"email@addisonavenue.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"551","name":"Navy Army Federal Credit Union","fid":"111904503","org":"Navy Army Federal Credit Union","url":"https://mybranch.navyarmyfcu.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-07-01 23:39:12","lastsslvalidation":"2012-04-09 22:23:43","profile":{"-addr1":"5725 Spohn Drive","-city":"Corpus Christi","-state":"TX","-postalcode":"78414","-country":"USA","-csphone":"361-986-4500","-tsphone":"800-622-3631","-url":"http://www.navyarmyccu.com","-email":"general@navyarmyccu.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true"}},{"id":"552","name":"Nevada Federal Credit Union","fid":"10888","org":"PSI","url":"https://ssl4.nevadafederal.org/ofxdirect/ofxrqst.aspx","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-09-04 22:26:54","lastsslvalidation":"2012-10-01 22:28:38","profile":{"-addr1":"2645 South Mojave","-city":"Las Vegas","-state":"NV","-postalcode":"98121","-country":"USA","-csphone":"(701) 457-1000","-url":"https://ssl8.onenevada.org/silverlink/login.asp","-email":"oncusupport@onenevada.org","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"553","name":"66 Federal Credit Union","fid":"289","org":"SixySix","url":"https://ofx.cuonlineaccounts.org","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-03-25 22:00:11","lastsslvalidation":"2012-03-25 22:00:10","profile":{"-addr1":"501 S. Johnstone","-city":"Bartlesville","-state":"ok","-postalcode":"74003","-country":"USA","-csphone":"918.336.7662","-tsphone":"918.337.7716","-url":"http://www.66fcu.org","-email":"talk2us@66fcu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"554","name":"FirstBank of Colorado","fid":"FirstBank","org":"FBDC","url":"https://www.efirstbankpfm.com/ofx/OFXServlet","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:05:31","lastsslvalidation":"2015-07-02 23:05:31","profile":{"-addr1":"12345 W Colfax Ave.","-city":"Lakewood","-state":"CO","-postalcode":"80215","-country":"USA","-csphone":"303-232-5522 or 800-964-3444","-url":"http://www.efirstbank.com","-email":"banking@efirstbank.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"555","name":"Continental Federal Credit Union","fid":"322077559","org":"Continenetal FCU","url":"https://cnt.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 01:46:33","lastsslvalidation":"2012-07-30 22:05:38"},{"id":"556","name":"Fremont Bank","fid":"121107882","org":"Fremont Bank","url":"https://ofx.fremontbank.com/OFXServer/FBOFXSrvr.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2014-05-27 22:24:23","lastsslvalidation":"2014-05-27 22:24:23","profile":{"-addr1":"39150 Fremont Blvd.","-city":"Fremont","-state":"CA","-postalcode":"94538","-country":"USA","-csphone":"(510) 505-5226","-tsphone":"(510) 505-5226","-url":"http://www.fremontbank.com","-email":"bankinfo@fremontbank.com","-signonmsgset":"true","-bankmsgset":"true","-emailmsgset":"true"}},{"id":"557","name":"Peninsula Community Federal Credit Union","fid":"325182344","org":"Peninsula Credit Union","url":"https://mas.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 01:57:43","lastsslvalidation":"2011-08-30 03:27:20"},{"id":"558","name":"Fidelity NetBenefits","fid":"8288","org":"nbofx.fidelity.com","brokerid":"nbofx.fidelity.com","url":"https://nbofx.fidelity.com/netbenefits/ofx/download","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:54:46","lastsslvalidation":"2015-07-02 22:54:46","profile":{"-addr1":"Fidelity Investments","-addr2":"P.O. Box 55017","-city":"Boston","-state":"MA","-postalcode":"02205","-country":"USA","-csphone":"800-581-5800","-tsphone":"800-581-5800","-url":"http://www.401k.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"559","name":"Fall River Municipal CU","fid":"211382591","org":"Fall River Municipal CU","url":"https://fal.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 01:47:14","lastsslvalidation":"2013-12-04 22:27:24"},{"id":"560","name":"University Credit Union","fid":"267077850","org":"University Credit Union","url":"https://umc.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-10-01 22:41:06","lastsslvalidation":"2013-10-01 22:41:05","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true"}},{"id":"561","name":"Dominion Credit Union","fid":"251082644","org":"Dominion Credit Union","url":"https://dom.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-09-24 22:11:50","lastsslvalidation":"2012-09-24 22:11:50","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"562","name":"HFS Federal Credit Union","fid":"321378660","org":"HFS Federal Credit Union","url":"https://hfs.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-16 01:48:08","lastsslvalidation":"2009-12-23 01:48:00"},{"id":"563","name":"IronStone Bank","fid":"5012","org":"Atlantic States Bank","url":"https://www.oasis.cfree.com/5012.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:16:00","lastsslvalidation":"2015-07-02 23:16:00"},{"id":"564","name":"Utah Community Credit Union","fid":"324377820","org":"Utah Community Credit Union","url":"https://ofx.uccu.com/scripts/isaofx.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-12-21 10:36:17","lastsslvalidation":"2015-11-04 02:03:24","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"565","name":"OptionsXpress, Inc","fid":"10876","org":"10876","brokerid":"optionxpress.com","url":"https://ofx.optionsxpress.com/cgi-bin/ox.exe","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:33:44","lastsslvalidation":"2015-07-02 23:33:42","profile":{"-addr1":"P. O. Box 2197","-city":"Chicago","-state":"Il","-postalcode":"60690-2197","-country":"USA","-csphone":"1-212-723-2898","-tsphone":"1-212-723-2898","-url":"https://ofx.optionsxpress.com/cgi-bin/ox.exe","-email":"alex_shnir@smb.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true","-notes":"Short sales may be imported as regular sell transactions Mutual fund purchases may show up as dividend reinvestments Other transaction types may be mis-labeled"}},{"id":"566","name":"Ariel Mutual Funds","org":"DST","brokerid":"ariel.com","url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=50017080411","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-12-28 09:57:53","lastsslvalidation":"2016-01-22 21:54:51","profile":{"-addr1":"P.O. Box 173375","-city":"Denver","-state":"CO","-postalcode":"80217","-country":"USA","-csphone":"816.345.7645","-tsphone":"816.345.7645","-url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=50900132018","-email":"service@americancentury.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"567","name":"Prudential Retirement","fid":"1271","org":"Prudential Retirement Services","brokerid":"prudential.com","url":"https://ofx.prudential.com/eftxweb/EFTXWebRedirector","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-12-24 17:21:33","lastsslvalidation":"2015-07-02 23:38:42","profile":{"-addr1":"Gateway Center 3","-addr2":"11th Floor","-city":"Newark","-state":"NJ","-postalcode":"07102","-country":"USA","-csphone":"(800)562-8838","-tsphone":"(732)482-6356","-url":"www.prudential.com/online/retirement/","-email":"rsofeedback@prudential.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"568","name":"Wells Fargo Investments, LLC","fid":"10762","org":"wellsfargo.com","brokerid":"wellsfargo.com","url":"https://invmnt.wellsfargo.com/inv/directConnect","ofxfail":"1","sslfail":"5","lastofxvalidation":"2011-09-28 22:29:26","lastsslvalidation":"2011-09-28 22:29:26","profile":{"-addr1":"420 Montgomery Street","-city":"San Francisco","-state":"CA","-postalcode":"94104","-country":"USA","-csphone":"1-877-823-7782","-tsphone":"1-800-956-4442","-url":"www.wellsfargo.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"569","name":"Cyprus Federal Credit Union","org":"Cyprus Federal Credit Union","url":"https://pctouchlink.cypruscu.com/ofx/ofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-08-13 22:08:00","lastsslvalidation":"2012-08-13 22:08:00","profile":{"-addr1":"P.O. Box 173375","-city":"Denver","-state":"CO","-postalcode":"80217","-country":"USA","-csphone":"816.345.7645","-tsphone":"816.345.7645","-url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=50900132018","-email":"service@americancentury.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"570","name":"Penson Financial Services","fid":"10780","org":"Penson Financial Services Inc","brokerid":"penson.com","url":"https://ofx.penson.com","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-02-03 22:35:47","lastsslvalidation":"2013-02-03 22:35:46","profile":{"-addr1":"1700 Pacific Ave","-addr2":"Suite 1400","-city":"Dallas","-state":"TX","-postalcode":"75201","-country":"USA","-csphone":"214.765.1100","-tsphone":"214.765.1100","-url":"http://www.penson.com","-email":"conversions@penson.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"571","name":"Tri Boro Federal Credit Union","fid":"243382747","org":"Tri Boro Federal Credit Union","url":"https://tri.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 02:05:57","lastsslvalidation":"2013-10-01 22:37:55"},{"id":"572","name":"Hewitt Associates LLC","fid":"242","org":"hewitt.com","brokerid":"hewitt.com","url":"https://seven.was.hewitt.com/eftxweb/access.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-12-12 05:09:20","lastsslvalidation":"2015-07-02 23:14:24","profile":{"-addr1":"100 Half Day Road","-addr2":"NONE","-addr3":"NONE","-city":"Lincolnshire","-state":"IL","-postalcode":"60069","-country":"USA","-csphone":"YOUR 401(K) PLAN","-tsphone":"YOUR 401(K) PLAN","-url":"www.hewitt.com","-email":"2","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"573","name":"Delta Community Credit Union","fid":"3328","org":"decu.org","url":"https://appweb.deltacommunitycu.com/ofxroot/directtocore.asp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-21 07:57:47","lastsslvalidation":"2016-01-21 08:01:04","profile":{"-addr1":"1025 Virgina Ave","-city":"Atlanta","-state":"GA","-postalcode":"30354","-country":"USA","-csphone":"800 954 3060","-tsphone":"800 954 3060","-url":"www.decu.org","-email":"itemp@decu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"574","name":"Huntington National Bank","fid":"3701","org":"Huntington","url":"https://onlinebanking.huntington.com/scripts/serverext.dll","ofxfail":"3","sslfail":"0","lastofxvalidation":"2009-12-23 01:48:54","lastsslvalidation":"2016-01-21 08:01:10"},{"id":"575","name":"WSECU","fid":"325181028","org":"WSECU","url":"https://ssl3.wsecu.org/ofxserver/ofxsrvr.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-21 18:38:01","lastsslvalidation":"2015-07-03 00:17:22","profile":{"-addr1":"330 Union Ave SE","-city":"Olympia","-state":"WA","-postalcode":"98501","-country":"USA","-csphone":"800-562-0999","-tsphone":"800-562-0999","-url":"www.wsecu.org","-email":"mfm.support@wsecu.org","-signonmsgset":"true","-bankmsgset":"true","-emailmsgset":"true"}},{"id":"576","name":"Baton Rouge City Parish Emp FCU","fid":"265473333","org":"Baton Rouge City Parish EFCU","url":"https://bat.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-10-01 22:06:12","lastsslvalidation":"2013-10-01 22:06:11","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"577","name":"Schools Financial Credit Union","fid":"90001","org":"Teknowledge","url":"https://ofx.schools.org/TekPortalOFX/servlet/TP_OFX_Controller","ofxfail":"1","sslfail":"5","lastofxvalidation":"2008-11-06 01:36:22","lastsslvalidation":"2008-12-09 01:34:33"},{"id":"578","name":"Charles Schwab Bank, N.A.","fid":"101","org":"ISC","brokerid":"SCHWAB.COM","url":"https://ofx.schwab.com/bankcgi_dev/ofx_server","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-22 21:51:38","lastsslvalidation":"2016-01-22 21:54:56","profile":{"-addr1":"101 Montgomery Street","-city":"San Francisco","-state":"CA","-postalcode":"94104","-country":"USA","-url":"WWW.SCHWAB.COM","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"579","name":"NW Preferred Federal Credit Union","fid":"323076575","org":"NW Preferred FCU","url":"https://nwf.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-01-01 22:33:54","lastsslvalidation":"2013-01-01 22:33:53","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"580","name":"Camino FCU","fid":"322279975","org":"Camino FCU","url":"https://homebanking.caminofcu.org/isaofx/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2011-12-05 22:04:38","lastsslvalidation":"2013-03-20 22:05:47","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"581","name":"Novartis Federal Credit Union","fid":"221278556","org":"Novartis FCU","url":"https://cib.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 01:57:32","lastsslvalidation":"2013-08-14 22:48:06"},{"id":"582","name":"U.S. First FCU","fid":"321076289","org":"US First FCU","url":"https://uff.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-09-30 01:46:28","lastsslvalidation":"2009-12-07 02:04:35"},{"id":"583","name":"FAA Technical Center FCU","fid":"231277440","org":"FAA Technical Center FCU","url":"https://ftc.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 01:47:13","lastsslvalidation":"2013-08-14 22:20:13"},{"id":"584","name":"Municipal Employees Credit Union of Baltimore, Inc.","fid":"252076468","org":"Municipal ECU of Baltimore,Inc.","url":"https://mec.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-10-30 01:39:35","lastsslvalidation":"2009-10-30 01:39:34"},{"id":"585","name":"Day Air Credit Union","fid":"242277808","org":"Day Air Credit Union","url":"https://pcu.dayair.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-03-24 22:06:38","lastsslvalidation":"2012-03-24 22:06:38","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"586","name":"Texas State Bank - McAllen","fid":"114909013","org":"Texas State Bank","url":"https://www.tsb-a.com/OFXServer/ofxsrvr.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2008-08-21 01:36:30","lastsslvalidation":"2008-08-21 01:36:29"},{"id":"587","name":"OCTFCU","fid":"17600","org":"OCTFCU","url":"https://ofx.octfcu.org","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:33:32","lastsslvalidation":"2015-07-02 23:33:27","profile":{"-addr1":"15442 Del Amo Ave","-city":"Tustin","-state":"CA","-postalcode":"92780","-country":"USA","-csphone":"714.258.8700","-tsphone":"714.258.8700","-url":"http://www.octfcu.org","-email":"info@octfcu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"588","name":"Hawaii State FCU","fid":"321379041","org":"Hawaii State FCU","url":"https://hse.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 01:47:55","lastsslvalidation":"2012-05-31 22:14:10"},{"id":"589","name":"Royce&Associates","org":"DST","brokerid":"www.roycefunds.com","url":"https://ofx.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=51714240204","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:43:37","lastsslvalidation":"2016-01-22 21:55:11","profile":{"-addr1":"P.O. Box 173375","-city":"Denver","-state":"CO","-postalcode":"80217","-country":"USA","-csphone":"816.345.7645","-tsphone":"816.345.7645","-url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=50900132018","-email":"service@americancentury.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"590","name":"American Funds","org":"DST","brokerid":"www.americanfunds.com","url":"https://www2.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=3000518","ofxfail":"3","sslfail":"0","lastofxvalidation":"2012-08-11 22:03:36","lastsslvalidation":"2016-01-26 00:21:10","profile":{"-addr1":"P.O. Box 173375","-city":"Denver","-state":"CO","-postalcode":"80217","-country":"USA","-csphone":"816.345.7645","-tsphone":"816.345.7645","-url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=50900132018","-email":"service@americancentury.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"591","name":"Wells Fargo Advantage Funds","org":"DST","brokerid":"dstsystems.com","url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=6181917141306","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-03 00:14:32","lastsslvalidation":"2016-01-22 21:55:13","profile":{"-addr1":"P.O. Box 173375","-city":"Denver","-state":"CO","-postalcode":"80217","-country":"USA","-csphone":"816.345.7645","-tsphone":"816.345.7645","-url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=50900132018","-email":"service@americancentury.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"592","name":"Community First Credit Union","fid":"275982801","org":"Community First Credit Union","url":"https://pcu.communityfirstcu.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2010-01-17 10:23:24","lastsslvalidation":"2014-01-16 22:14:26"},{"id":"593","name":"MTC Federal Credit Union","fid":"053285173","org":"MTC Federal Credit Union","url":"https://mic.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 01:53:21","lastsslvalidation":"2009-12-23 01:53:20"},{"id":"594","name":"Home Federal Savings Bank(MN/IA)","fid":"291270050","org":"VOneTwentySevenG","url":"https://ofx1.evault.ws/ofxserver/ofxsrvr.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-11-19 21:37:21","lastsslvalidation":"2015-12-18 06:00:54"},{"id":"595","name":"Reliant Community Credit Union","fid":"222382438","org":"W.C.T.A Federal Credit Union","url":"https://wct.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-10-10 22:29:05","lastsslvalidation":"2013-08-14 22:55:22","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"596","name":"Patriots Federal Credit Union","fid":"322281963","org":"PAT FCU","url":"https://pat.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-07-17 22:33:26","lastsslvalidation":"2013-08-14 22:52:53","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"597","name":"SafeAmerica Credit Union","fid":"321171757","org":"SafeAmerica Credit Union","url":"https://saf.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-08-14 22:55:40","lastsslvalidation":"2013-08-14 22:55:40","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"598","name":"Mayo Employees Federal Credit Union","fid":"291975478","org":"Mayo Employees FCU","url":"https://homebank.mayocreditunion.org/ofx/ofx.dll","ofxfail":"3","sslfail":"4","lastofxvalidation":"2011-11-03 22:18:43","lastsslvalidation":"2011-11-03 22:18:43","profile":{"-addr1":"200 First Street SW","-city":"Rochester","-state":"MN","-postalcode":"30008","-country":"USA","-csphone":"800-535-2129","-url":"https://homebank.mayocreditunion.org","-email":"test@test.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"599","name":"FivePoint Credit Union","fid":"313187571","org":"FivePoint Credit Union","url":"https://tfcu-nfuse01.texacocommunity.org/internetconnector/isaofx.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-19 10:42:27","lastsslvalidation":"2015-12-23 08:47:47","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"600","name":"Community Resource Bank","fid":"091917160","org":"CNB","url":"https://www.cnbinternet.com/OFXServer/ofxsrvr.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-21 23:33:02","lastsslvalidation":"2016-01-20 06:21:07","profile":{"-addr1":"1605 Heritage Drive","-city":"Northfield","-state":"MN","-postalcode":"55057","-country":"USA","-csphone":"800-250-8420","-url":"https://www.community-resourcebank.com","-email":"crb@community-resourcebank.com","-signonmsgset":"true","-bankmsgset":"true","-emailmsgset":"true"}},{"id":"601","name":"Security 1st FCU","fid":"314986292","org":"Security 1st FCU","url":"https://sec.usersonlnet.com/scripts/isaofx.dll","ofxfail":"3","sslfail":"4","lastofxvalidation":"2011-07-17 22:22:56","lastsslvalidation":"2013-10-01 22:34:49"},{"id":"602","name":"First Alliance Credit Union","fid":"291975481","org":"First Alliance Credit Union","url":"https://fia.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2011-06-27 22:09:42","lastsslvalidation":"2013-10-01 22:16:20"},{"id":"603","name":"Billings Federal Credit Union","fid":"6217","org":"Billings Federal Credit Union","url":"https://bfcuonline.billingsfcu.org/ofx/ofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-03-03 22:19:49","lastsslvalidation":"2012-06-25 22:03:12","profile":{"-addr1":"2522 4th Ave. North","-city":"Billings","-state":"MT","-postalcode":"59101","-country":"USA","-csphone":"1-800-331-5470, local 406 248-1127","-url":"https://bfcuonline.billingsfcu.org","-email":"billingsfcu@billingsfcu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"604","name":"Windward Community FCU","fid":"321380315","org":"Windward Community FCU","url":"https://wwc.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-08-09 22:37:26","lastsslvalidation":"2012-08-09 22:37:26","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"605","name":"Bernstein Global Wealth Mgmt","org":"BGWM","brokerid":"Bernstein.com","url":"https://ofx.bernstein.com/OFXServer/ofxsrvr.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:26:24","lastsslvalidation":"2015-07-02 22:26:24","profile":{"-addr1":"P.O. Box 173375","-city":"Denver","-state":"CO","-postalcode":"80217","-country":"USA","-csphone":"816.345.7645","-tsphone":"816.345.7645","-url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=50900132018","-email":"service@americancentury.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"606","name":"Siouxland Federal Credit Union","fid":"304982235","org":"SIOUXLAND FCU","url":"https://sio.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2011-07-31 22:24:11","lastsslvalidation":"2013-10-01 22:35:54"},{"id":"607","name":"The Queen\'s Federal Credit Union","fid":"321379504","org":"The Queens Federal Credit Union","url":"https://que.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2011-06-05 22:21:37","lastsslvalidation":"2011-07-24 22:25:40"},{"id":"608","name":"Edward Jones","fid":"823","org":"Edward Jones","brokerid":"www.edwardjones.com","url":"https://ofx.edwardjones.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-24 20:05:09","lastsslvalidation":"2016-01-16 19:37:20","profile":{"-addr1":"12555 Manchester Road","-city":"Saint Louis","-state":"MO","-postalcode":"63131","-country":"USA","-csphone":"800.441.0503","-tsphone":"800.441.0503","-url":"https://www.edwardjones.com","-email":"accountaccess@edwardjones.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-invstmtmsgset":"true","-emailmsgset":"true","-seclistmsgset":"true"}},{"id":"609","name":"Merck Sharp&Dohme FCU","fid":"231386645","org":"MERCK, SHARPE&DOHME FCU","url":"https://msd.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-01-18 22:17:16","lastsslvalidation":"2012-01-18 22:17:15","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"610","name":"Credit Union 1 - IL","fid":"271188081","org":"Credit Union 1","url":"https://pcu.creditunion1.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 01:46:34","lastsslvalidation":"2009-12-23 01:46:33"},{"id":"611","name":"Bossier Federal Credit Union","fid":"311175129","org":"Bossier Federal Credit Union","url":"https://bos.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-11-24 01:41:48","lastsslvalidation":"2013-10-01 22:06:33"},{"id":"612","name":"First Florida Credit Union","fid":"263079014","org":"First Llorida Credit Union","url":"https://pcu2.gecuf.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-02-04 22:54:04","lastsslvalidation":"2013-02-21 22:20:33","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"613","name":"NorthEast Alliance FCU","fid":"221982130","org":"NorthEast Alliance FCU","url":"https://nea.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-12-23 01:57:27","lastsslvalidation":"2013-08-14 22:42:22"},{"id":"614","name":"ShareBuilder","fid":"5575","org":"ShareBuilder","brokerid":"sharebuilder.com","url":"https://ofx.sharebuilder.com","ofxfail":"0","sslfail":"4","lastofxvalidation":"2016-01-14 17:48:25","lastsslvalidation":"2015-05-14 23:46:36","profile":{"-addr1":"1445 120th Ave NE","-city":"Bellevue","-state":"WA","-postalcode":"98005","-country":"USA","-csphone":"(800) 747-2537","-url":"http://www.sharebuilder.com","-email":"customercare@sharebuilder.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"615","name":"Janus","brokerid":"janus.com","url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=50900132018","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-10 12:05:29","lastsslvalidation":"2016-01-24 01:26:49","profile":{"-addr1":"P.O. Box 173375","-city":"Denver","-state":"CO","-postalcode":"80217","-country":"USA","-csphone":"816.345.7645","-tsphone":"816.345.7645","-url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=50900132018","-email":"service@americancentury.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"616","name":"Weitz Funds","fid":"weitz.com","org":"weitz.com","brokerid":"weitz.com","url":"https://www3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=52204081925","ofxfail":"3","sslfail":"0","lastofxvalidation":"2012-08-10 22:54:22","lastsslvalidation":"2016-01-21 08:01:56"},{"id":"617","name":"JPMorgan Retirement Plan Services","fid":"6313","org":"JPMORGAN","brokerid":"JPMORGAN","url":"https://ofx.retireonline.com/eftxweb/access.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-13 14:26:09","lastsslvalidation":"2015-09-01 03:49:10","profile":{"-addr1":"9300 Ward Parkway","-city":"Kansas City","-state":"MO","-postalcode":"64114","-country":"USA","-csphone":"1-800-345-2345","-tsphone":"1-800-345-2345","-url":"http://www.retireonline.com","-email":"2","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"618","name":"Credit Union ONE","fid":"14412","org":"Credit Union ONE","url":"https://cuhome.cuone.org/ofx/ofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2014-11-23 22:28:40","lastsslvalidation":"2013-06-25 22:23:46","profile":{"-addr1":"400 E. Nine Mile Road","-city":"Ferndale","-state":"MI","-postalcode":"48220","-country":"USA","-csphone":"800-451-4292","-url":"http://www.cuone.org","-email":"cuomembers@cuone.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"619","name":"Salt Lake City Credit Union","fid":"324079186","org":"Salt Lake City Credit Union","url":"https://slc.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-02-27 01:35:09","lastsslvalidation":"2009-12-23 02:01:48"},{"id":"620","name":"First Southwest Company","fid":"7048","org":"AFS","brokerid":"https://fswofx.automat","url":"https://fswofx.automatedfinancial.com","ofxfail":"0","sslfail":"4","lastofxvalidation":"2016-01-09 07:33:24","lastsslvalidation":"2015-07-30 06:37:35","profile":{"-addr1":"50 Broadway","-city":"New York","-state":"NY","-postalcode":"10004","-country":"USA","-url":"https://fswofx.automatedfinancial.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"621","name":"Dodge&Cox Funds","brokerid":"dodgeandcox.com","url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=50314030604","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:46:23","lastsslvalidation":"2016-01-23 09:34:18","profile":{"-addr1":"P.O. Box 173375","-city":"Denver","-state":"CO","-postalcode":"80217","-country":"USA","-csphone":"816.345.7645","-tsphone":"816.345.7645","-url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=50900132018","-email":"service@americancentury.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"622","name":"Wells Fargo Trust-Investment Mgt","fid":"6955","org":"Wells Fargo Trust","brokerid":"Wells Fargo Trust","url":"https://trust.wellsfargo.com/trust/directConnect","ofxfail":"2","sslfail":"0","lastofxvalidation":"2011-09-29 22:30:17","lastsslvalidation":"2015-11-12 11:41:29","profile":{"-addr1":"733 Marquette Ave, 5th Floor","-addr2":"Security Control & Transfer","-city":"Minneapolis","-state":"MN","-postalcode":"55479","-country":"USA","-csphone":"1-800-352-3702","-tsphone":"1-800-956-4442","-url":"www.wellsfargo.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"623","name":"Scottrade, Inc.","fid":"777","org":"Scottrade","brokerid":"www.scottrade.com","url":"https://ofxstl.scottsave.com","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-02-22 23:39:30","lastsslvalidation":"2011-09-28 22:22:22","profile":{"-addr1":"12855 Flushing Meadows Dr.","-city":"St. Louis","-state":"MO","-postalcode":"63131","-country":"USA","-csphone":"314.965.1555","-tsphone":"314.965.1555","-url":"http://www.scottrade.com","-email":"support@scottrade.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"624","name":"Silver State Schools CU","fid":"322484265","org":"SSSCU","url":"https://www.silverstatecu.com/OFXServer/ofxsrvr.dll","ofxfail":"3","sslfail":"5","lastofxvalidation":"2012-04-16 22:27:15","lastsslvalidation":"2012-04-16 22:27:15","profile":{"-addr1":"4221 South McLeod","-city":"Las Vegas","-state":"NV","-postalcode":"89121","-country":"USA","-csphone":"800-357-9654","-url":"www.silverstatecu.com","-email":"support@silverstatecu.com","-signonmsgset":"true","-bankmsgset":"true","-emailmsgset":"true"}},{"id":"625","name":"Smith Barney - Investments","brokerid":"smithbarney.com","url":"https://ofx.smithbarney.com/cgi-bin/ofx/ofx.cgi","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-07-20 22:42:55","lastsslvalidation":"2013-07-20 22:42:49","profile":{"-addr1":"P.O. Box 173375","-city":"Denver","-state":"CO","-postalcode":"80217","-country":"USA","-csphone":"816.345.7645","-tsphone":"816.345.7645","-url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=50900132018","-email":"service@americancentury.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"626","name":"VISA Information Source","fid":"10942","org":"VISA","url":"https://vis.informationmanagement.visa.com/eftxweb/access.ofx","ofxfail":"1","sslfail":"0","lastofxvalidation":"2015-07-16 14:38:48","lastsslvalidation":"2015-07-03 00:11:15","profile":{"-addr1":"900 Metro Center Blvd","-city":"Foster City","-state":"CA","-postalcode":"94404","-country":"USA","-csphone":"212 344 2000","-tsphone":"212 344 2000","-url":"www.joineei.com","-email":"support@joineei.com","-signonmsgset":"true","-creditcardmsgset":"true"}},{"id":"627","name":"National City","fid":"5860","org":"NATIONAL CITY","url":"https://ofx.nationalcity.com/ofx/OFXConsumer.aspx","ofxfail":"1","sslfail":"5","lastofxvalidation":"2009-10-24 01:39:34","lastsslvalidation":"2014-07-26 22:32:20"},{"id":"628","name":"Capital One","fid":"1001","org":"Hibernia","url":"https://onlinebanking.capitalone.com/scripts/serverext.dll","ofxfail":"2","sslfail":"0","lastofxvalidation":"2009-08-21 01:33:29","lastsslvalidation":"2015-07-02 22:28:14","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"629","name":"Citi Credit Card","fid":"24909","org":"Citigroup","url":"https://www.accountonline.com/cards/svc/CitiOfxManager.do","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-12-09 05:57:58","lastsslvalidation":"2015-07-02 22:33:34","profile":{"-addr1":"8787 Baypine Road","-city":"Jacksonville","-state":"FL","-postalcode":"32256","-country":"USA","-csphone":"1-800-950-5114","-tsphone":"1-800-347-4934","-url":"http://www.citicards.com","-signonmsgset":"true","-creditcardmsgset":"true"}},{"id":"630","name":"Zions Bank","fid":"1115","org":"244-3","url":"https://quicken.metavante.com/ofx/OFXServlet","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-03 00:17:25","lastsslvalidation":"2015-07-03 00:17:25","profile":{"-addr1":"2200 South 3270 West","-city":"West Valley City","-state":"UT","-postalcode":"84119","-country":"USA","-csphone":"1-888-440-0339","-tsphone":"1-888-440-0339","-url":"www.zionsbank.com","-email":"zionspfm@zionsbank.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-interxfermsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"631","name":"Capital One Bank","fid":"1001","org":"Hibernia","url":"https://onlinebanking.capitalone.com/scripts/serverext.dll","ofxfail":"2","sslfail":"0","lastofxvalidation":"2009-08-21 01:33:30","lastsslvalidation":"2016-01-21 11:05:48","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"633","name":"Redstone Federal Credit Union","fid":"2143","org":"Harland Financial Solutions","url":"https://remotebanking.redfcu.org/ofx/ofx.dll","ofxfail":"3","sslfail":"4","lastofxvalidation":"2009-10-31 01:44:13","lastsslvalidation":"2009-10-31 01:44:12"},{"id":"634","name":"PNC Bank","fid":"4501","org":"ISC","url":"https://www.oasis.cfree.com/fip/genesis/prod/04501.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-13 22:15:53","lastsslvalidation":"2015-11-22 22:15:29","profile":{"-addr1":"P.O. Box 339","-city":"Pittsburgh","-state":"PA","-postalcode":"152309736","-country":"USA","-url":"http://www.pncbank.com/","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"635","name":"Bank of America (California)","fid":"6805","org":"HAN","url":"https://ofx.bankofamerica.com/cgi-forte/ofx?servicename=ofx_2-3&pagename=bofa","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-05-03 22:15:30","lastsslvalidation":"2015-05-03 22:15:30","profile":{"-addr1":"Interactive Banking","-addr2":"TX1-854-06-12","-addr3":"P.O. Box 655961","-city":"Dallas","-state":"TX","-postalcode":"75265-9964","-country":"USA","-csphone":"800-792-0808","-tsphone":"800-792-0808","-url":"http://www.bankofamerica.com","-email":"forte@bankofamerica.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"636","name":"Chase (credit card) ","fid":"10898","org":"B1","url":"https://ofx.chase.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-22 21:51:52","lastsslvalidation":"2015-10-22 08:05:10","profile":{"-addr1":"Bank One Plaza","-addr2":"Suite IL1-0852","-city":"Chicago","-state":"IL","-postalcode":"60670","-country":"USA","-csphone":"800-482-3675","-tsphone":"800-482-3675","-url":"https://www.chase.com","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"637","name":"Arizona Federal Credit Union","fid":"322172797","org":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:19:24","lastsslvalidation":"2015-07-02 22:19:23","profile":{"-addr1":"333 N 44th Street","-city":"Phoenix","-state":"AZ","-postalcode":"85008","-country":"USA","-csphone":"800-523-4603","-tsphone":"800-523-4603","-url":"www.azfcu.org","-email":"member.services@azfcu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"638","name":"UW Credit Union","fid":"1001","org":"UWCU","url":"https://ofx.uwcu.org/serverext.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-22 21:51:55","lastsslvalidation":"2015-07-03 00:09:33","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"639","name":"Bank of America","fid":"5959","org":"HAN","url":"https://eftx.bankofamerica.com/eftxweb/access.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-16 09:15:20","lastsslvalidation":"2016-01-22 21:55:22","profile":{"-addr1":"Interactive Banking","-addr2":"TX1-854-06-12","-addr3":"P.O. Box 655961","-city":"Dallas","-state":"TX","-postalcode":"75265-9964","-country":"USA","-csphone":"(800) 933-6262","-tsphone":"(800) 933-6262","-url":"http://www.bankofamerica.com","-email":"forte@bankofamerica.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"640","name":"Commerce Bank","fid":"1001","org":"CommerceBank","url":"https://ofx.tdbank.com/scripts/serverext.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-11-29 13:55:14","lastsslvalidation":"2015-07-02 22:35:34","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"641","name":"Securities America","fid":"7784","org":"Fidelity","brokerid":"1234","url":"https://ofx.ibgstreetscape.com:443","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:53:19","lastsslvalidation":"2015-07-02 23:53:19","profile":{"-addr1":"XXXXXXXXXX","-city":"XXXXXXXXXX","-state":"XX","-postalcode":"XXXXX","-country":"USA","-csphone":"Contact your broker/dealer.","-tsphone":"Contact your broker/dealer.","-url":"https://ofx.ibgstreetscape.com","-signonmsgset":"true","-invstmtmsgset":"true"}},{"id":"642","name":"First Internet Bank of Indiana","fid":"074014187","org":"DI","brokerid":"074014187","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:03:07","lastsslvalidation":"2015-07-02 23:03:06","profile":{"-addr1":"7820 Innovation Boulevard","-addr2":"Suite 210","-city":"Indianapolis","-state":"IN","-postalcode":"46278","-country":"USA","-csphone":"(888) 873-3424","-tsphone":"(888) 873-3424","-url":"www.firstib.com","-email":"newaccounts@firstib.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"643","name":"Alpine Banks of Colorado","fid":"1451","org":"JackHenry","url":"https://directline.netteller.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:07:32","lastsslvalidation":"2015-07-02 22:07:32","profile":{"-addr1":"2200 GRAND AVE","-addr2":"GLENWOOD SPRINGS, CO  81601","-city":"GRAND JUNCTION","-state":"CO","-postalcode":"815010000","-country":"USA","-csphone":"(970) 945-2424","-tsphone":"800-551-6098","-url":"http://www.alpinebank.com","-email":"onlinebanking@alpinebank.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"644","name":"BancFirst","fid":"103003632","org":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-15 12:01:29","lastsslvalidation":"2016-01-22 20:18:17","profile":{"-addr1":"101 N. Broadway,Suite 200","-city":"Oklahoma City","-state":"OK","-postalcode":"73102","-country":"USA","-csphone":"405-270-4785","-tsphone":"405-270-4785","-url":"www.bancfirst.com","-email":"onlinebanking@bancfirst.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"645","name":"Desert Schools Federal Credit Union","fid":"1001","org":"DSFCU","url":"https://epal.desertschools.org/scripts/serverext.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:45:34","lastsslvalidation":"2015-07-02 22:45:34","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"646","name":"Kinecta Federal Credit Union","fid":"322278073","org":"KINECTA","url":"https://ofx.kinecta.org/OFXServer/ofxsrvr.dll","ofxfail":"0","sslfail":"5","lastofxvalidation":"2016-01-22 05:21:18","lastsslvalidation":"2015-06-14 23:13:08","profile":{"-addr1":"1440 Rosecrans Avenue","-city":"Manhattan Beach","-state":"CA","-postalcode":"90266","-country":"USA","-csphone":"800-854-9846","-tsphone":"800-854-9846","-url":"http://www.kinecta.org","-email":"ofxsupport@kinecta.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"325081403","name":"Boeing Employees Credit Union","fid":"3670","org":"BECU","url":"https://onlinebanking.becu.org/ofx/ofxprocessor.asp","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-02-23 22:19:52","lastsslvalidation":"2015-10-24 10:08:03","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"648","name":"Capital One Bank - 2","fid":"1001","org":"Hibernia","url":"https://onlinebanking.capitalone.com/ofx/process.ofx","ofxfail":"2","sslfail":"0","lastofxvalidation":"2015-02-06 04:35:52","lastsslvalidation":"2015-07-02 22:28:28","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"649","name":"Michigan State University Federal CU","fid":"272479663","org":"MSUFCU","url":"https://ofx.msufcu.org/ofxserver/ofxsrvr.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:23:14","lastsslvalidation":"2015-07-02 23:23:14","profile":{"-addr1":"3777 West Road","-city":"East Lansing","-state":"MI","-postalcode":"48823","-country":"USA","-csphone":"1-800-678-4968","-tsphone":"1-517-333-2310","-url":"http://www.msufcu.org","-email":"eservices@msufcu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"650","name":"The Community Bank","fid":"211371476","org":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-12-08 01:13:12","lastsslvalidation":"2015-07-02 23:59:13","profile":{"-addr1":"1265 Belmont Street","-city":"Brockton","-state":"MA","-postalcode":"02301-4401","-country":"USA","-csphone":"508-587-3210","-tsphone":"508-587-3210","-url":"www.communitybank.com","-email":"trocha@communitybank.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"651","name":"Sacramento Credit Union","fid":"1","org":"SACRAMENTO CREDIT UNION","url":"https://homebank.sactocu.org/ofx/ofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-05-10 23:34:15","lastsslvalidation":"2015-05-10 23:34:14","profile":{"-addr1":"P.O. BOX 2351","-city":"Sacramento","-state":"CA","-postalcode":"95812","-country":"USA","-csphone":"916 444 6070","-url":"https://homebank.sactocu.org","-email":"info@sactocu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"652","name":"TD Bank","fid":"1001","org":"CommerceBank","url":"https://onlinebanking.tdbank.com/scripts/serverext.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-22 21:52:41","lastsslvalidation":"2016-01-21 08:02:34","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"653","name":"Suncoast Schools FCU","fid":"1001","org":"SunCoast","url":"https://ofx.suncoastfcu.org","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-02-13 23:49:01","lastsslvalidation":"2013-10-23 22:31:20","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"654","name":"Metro Bank","fid":"9970","org":"MTRO","url":"https://ofx.mymetrobank.com/ofx/ofx.ofx","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-11-08 15:35:21","lastsslvalidation":"2015-11-19 15:25:09","profile":{"-addr1":"3801 Paxton St","-city":"Harrisburg","-state":"PA","-postalcode":"17111","-country":"USA","-csphone":"800-204-0541","-tsphone":"800-204-0541","-url":"https://online.mymetrobank.com","-email":"customerservice@mymetrobank.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"655","name":"First National Bank (Texas)","fid":"12840","org":"JackHenry","url":"https://directline.netteller.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-12-12 15:08:50","lastsslvalidation":"2015-07-02 23:03:09","profile":{"-addr1":"PO BOX 810","-addr2":"EDINBURG TEXAS 78540-0810","-city":"LUBBOCK","-state":"TX","-postalcode":"794160000","-country":"USA","-csphone":"(956) 380-8500","-tsphone":"1-877-380-8573","-url":"http://www.webfnb.com","-email":"FNB-WebBanking@plainscapital.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"656","name":"Bank of the West","fid":"5809","org":"BancWest Corp","url":"https://olbp.bankofthewest.com/ofx0002/ofx_isapi.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-05-07 22:15:37","lastsslvalidation":"2015-05-07 22:15:36","profile":{"-addr1":"1450 Treat Blvd","-city":"Walnut Creek","-state":"CA","-postalcode":"94596","-country":"USA","-csphone":"1-800-488-2265","-tsphone":"1-800-488-2265","-url":"http://www.bankofthewest.com","-email":"etimebanker@bankofthewest.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"657","name":"Mountain America Credit Union","fid":"324079555","org":"MACU","url":"https://ofx.macu.org/OFXServer/ofxsrvr.dll","ofxfail":"0","sslfail":"4","lastofxvalidation":"2015-11-05 12:52:18","lastsslvalidation":"2013-11-20 22:24:51","profile":{"-addr1":"7181 S Campus View Dr","-city":"West Jordan","-state":"UT","-postalcode":"84084","-country":"USA","-csphone":"800-748-4302","-tsphone":"1-800-748-4302","-url":"https://www.macu.com","-email":"macumail@macu.com","-signonmsgset":"true","-bankmsgset":"true","-emailmsgset":"true"}},{"id":"658","name":"ING DIRECT","fid":"031176110","org":"ING DIRECT","url":"https://ofx.ingdirect.com/OFX/ofx.html","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-03-15 23:07:36","lastsslvalidation":"2015-03-15 23:07:35"},{"id":"659","name":"Santa Barbara Bank & Trust","fid":"5524","org":"pfm-l3g","url":"https://pfm.metavante.com/ofx/OFXServlet","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:49:58","lastsslvalidation":"2015-07-02 23:49:57","profile":{"-addr1":"P. O. Box 60839","-city":"Santa Barbara","-state":"CA","-postalcode":"93160","-country":"USA","-csphone":"1-888-400-7228","-url":"http://www.pcbancorp.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-interxfermsgset":"true","-billpaymsgset":"true"}},{"id":"660","name":"UMB","fid":"468","org":"UMBOFX","url":"https://ofx.umb.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-12-06 15:52:56","lastsslvalidation":"2015-07-03 00:05:26"},{"id":"661","name":"Bank Of America(All except CA,WA,&ID ","fid":"6812","org":"HAN","brokerid":"IDX name=Claw","url":"Https://ofx.bankofamerica.com/cgi-forte/fortecgi?servicename=ofx_2-3&pagename=ofx ","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-05-03 22:15:34","lastsslvalidation":"2015-05-03 22:15:34","profile":{"-addr1":"Interactive Banking","-addr2":"TX1-854-06-12","-addr3":"P.O. Box 655961","-city":"Dallas","-state":"TX","-postalcode":"75265-9964","-country":"USA","-csphone":"(800) 933-6262","-tsphone":"(800) 933-6262","-url":"http://www.bankofamerica.com","-email":"forte@bankofamerica.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"662","name":"Centra Credit Union2","fid":"274972883","org":"Centra CU","url":"https://www.centralink.org/scripts/isaofx.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:28:35","lastsslvalidation":"2015-07-02 22:28:35","profile":{"-addr1":"1430 National Road","-city":"Columbus","-state":"IN","-postalcode":"47201","-country":"USA","-csphone":"800-232-3642","-tsphone":"800-232-3642","-url":"http://www.centra.org","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true"}},{"id":"663","name":"Mainline National Bank","fid":"9869","org":"JackHenry","url":"https://directline.netteller.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-25 19:20:00","lastsslvalidation":"2016-01-21 08:02:58"},{"id":"664","name":"Citizens Bank","fid":"4639","org":"CheckFree OFX","url":"https://www.oasis.cfree.com/04639.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:33:52","lastsslvalidation":"2015-07-02 22:33:51"},{"id":"665","name":"USAA Investment Mgmt Co","fid":"24592","org":"USAA","brokerid":"USAA.COM","url":"https://service2.usaa.com/ofx/OFXServlet","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-03 00:09:25","lastsslvalidation":"2015-09-15 12:29:03","profile":{"-addr1":"Attn:USAA BrokSvcs/MutualFunds","-addr2":"PO BOX 659453","-city":"San Antonio","-state":"TX","-postalcode":"78265-9825","-country":"USA","-csphone":"800-531-8777","-tsphone":"877-632-3002","-url":"https://www.usaa.com/inet/gas_imco/ImMainMenu","-signonmsgset":"true","-invstmtmsgset":"true"}},{"id":"666","name":"121 Financial Credit Union","fid":"000001155","org":"121 Financial Credit Union","url":"https://ppc.121fcu.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2014-11-16 22:00:03","lastsslvalidation":"2011-07-03 22:00:04","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"667","name":"Abbott Laboratories Employee CU","fid":"35MXN","org":"Abbott Laboratories ECU - ALEC","url":"https://www.netit.financial-net.com/ofx/","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:02:31","lastsslvalidation":"2015-07-02 22:02:30","profile":{"-addr1":"401 N. RIVERSIDE DRIVE","-city":"GURNEE","-state":"IL","-postalcode":"60031","-country":"US","-url":"https://www.netit.financial-net.com/alec","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"668","name":"Achieva Credit Union","fid":"4491","org":"Achieva Credit Union","url":"https://rbserver.achievacu.com/ofx/ofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-05-18 22:02:34","lastsslvalidation":"2015-05-18 22:02:33","profile":{"-addr1":"1499 Gulf to Bay Blvd","-city":"Clearwater","-state":"FL","-postalcode":"34653","-country":"USA","-csphone":"727-431-7680","-url":"https://rbserver.achievacu.com","-email":"john@achievacu.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"669","name":"American National Bank","fid":"4201","org":"ISC","url":"https://www.oasis.cfree.com/fip/genesis/prod/04201.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:16:05","lastsslvalidation":"2015-07-02 22:16:04","profile":{"-addr1":"33 N. Lasalle","-city":"Chicago","-state":"IL","-postalcode":"60602","-country":"USA","-url":"http://www.americannationalbank.com/","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"670","name":"Andrews Federal Credit Union","fid":"AFCUSMD","org":"FundsXpress","url":"https://ofx.fundsxpress.com/piles/ofx.pile/","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-11-24 15:19:40","lastsslvalidation":"2015-11-12 21:23:30","profile":{"-addr1":"5711 Allentown Road","-city":"Suitland","-state":"MD","-postalcode":"20746","-country":"USA","-csphone":"800.487.5500 (U.S.) 0.800.487.56","-tsphone":"800.487.5500 (U.S.) 0.800.487.56","-url":"http://www.andrewsfcu.org","-email":"memberservice@andrewsfcu.org","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"671","name":"Citi Personal Wealth Management","fid":"060","org":"Citigroup","brokerid":"investments.citi.com","url":"https://uat-ofx.netxclient.inautix.com/cgi/OFXNetx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-23 18:01:40","lastsslvalidation":"2015-07-23 17:42:27","profile":{"-addr1":"2 Court Square","-city":"Long Island City","-state":"NY","-postalcode":"11120","-country":"USA","-csphone":"877-541-1852","-tsphone":"877-541-1852","-url":"http://www.investments.citi.com/pwm","-email":"-","-signonmsgset":"true","-invstmtmsgset":"true"}},{"id":"672","name":"Bank One (Chicago)","fid":"1501","org":"ISC","url":"https://www.oasis.cfree.com/fip/genesis/prod/01501.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:24:31","lastsslvalidation":"2015-07-02 22:24:31","profile":{"-addr1":"P. O. Box 1762","-city":"Chicago","-state":"IL","-postalcode":"606909947","-country":"USA","-url":"http://www.bankone.com/","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"673","name":"Bank One (Michigan and Florida)","fid":"6001","org":"ISC","url":"https://www.oasis.cfree.com/fip/genesis/prod/06001.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-11 14:25:54","lastsslvalidation":"2015-07-02 22:24:32","profile":{"-addr1":"P.O. Box 7082","-city":"Troy","-state":"MI","-postalcode":"480077082","-country":"USA","-url":"http://www.bankone.com/","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"674","name":"Bank of America (Formerly Fleet)","fid":"1803","org":"ISC","url":"https://www.oasis.cfree.com/fip/genesis/prod/01803.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:22:45","lastsslvalidation":"2015-07-02 22:22:45","profile":{"-addr1":"MA CPK 04-02-08","-addr2":"P.O. Box 1924","-city":"Boston","-state":"MA","-postalcode":"021059940","-country":"USA","-url":"http://www.bankboston.com/","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"675","name":"BankBoston PC Banking","fid":"1801","org":"ISC","url":"https://www.oasis.cfree.com/fip/genesis/prod/01801.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:24:33","lastsslvalidation":"2015-07-02 22:24:33","profile":{"-addr1":"MA CPK 04-02-08","-addr2":"P.O. Box 1924","-city":"Boston","-state":"MA","-postalcode":"021059940","-country":"USA","-url":"http://www.bankboston.com/","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"676","name":"Beverly Co-Operative Bank","fid":"531","org":"orcc","url":"https://www19.onlinebank.com/OROFX16Listener","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-05-31 22:10:16","lastsslvalidation":"2014-08-24 22:07:54","profile":{"-addr1":"254 Cabot Street","-city":"Beverly","-state":"MA","-postalcode":"01915","-country":"USA","-csphone":"(877) 314-7816","-tsphone":"(877) 314-7816","-url":"http://www.beverlycoop.com","-email":"info@orcc.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"677","name":"Cambridge Portuguese Credit Union","fid":"983","org":"orcc","url":"https://www20.onlinebank.com/OROFX16Listener","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:28:10","lastsslvalidation":"2015-07-02 22:28:09","profile":{"-addr1":"493 Somerville Avenue","-city":"Somerville","-state":"MA","-postalcode":"02143","-country":"USA","-csphone":"(877) 793-1440","-tsphone":"(877) 793-1440","-url":"http://www.naveo.org","-email":"info@orcc.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"678","name":"Citibank","fid":"2101","org":"ISC","url":"https://www.oasis.cfree.com/fip/genesis/prod/02101.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:33:50","lastsslvalidation":"2015-07-02 22:33:50","profile":{"-addr1":"500 W. Madison","-city":"Chicago","-state":"IL","-postalcode":"60661","-country":"USA","-url":"http://www.citibank.com/","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"679","name":"Community Bank, N.A.","fid":"11517","org":"JackHenry","url":"https://directline2.netteller.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:35:40","lastsslvalidation":"2016-01-21 08:03:03","profile":{"-addr1":"45 - 49 Court Street","-addr2":"Canton, NY 13617","-city":"CANTON","-state":"NY","-postalcode":"136170000","-country":"USA","-csphone":"(315) 386-4553","-tsphone":"1-866-764-8638","-url":"http://www.communitybankna.com","-email":"corpcom@communitybankna.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"680","name":"Consumers Credit Union","fid":"12541","org":"Consumers Credit Union","url":"https://ofx.lanxtra.com/ofx/servlet/Teller","ofxfail":"0","sslfail":"4","lastofxvalidation":"2016-01-26 00:01:44","lastsslvalidation":"2013-08-19 22:09:48","profile":{"-addr1":"7040 Stadium Dr.","-city":"Oshtemo","-state":"MI","-postalcode":"49077","-country":"USA","-csphone":"2693457804","-tsphone":"2693457804","-url":"http://www.consumerscu.org","-email":"ccu@consumerscu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"681","name":"CPM Federal Credit Union","fid":"253279536","org":"USERS, Inc.","url":"https://cpm.usersonlnet.com/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-01-31 22:06:38","lastsslvalidation":"2013-08-14 22:12:56","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"682","name":"DATCU","fid":"311980725","org":"DATCU","url":"https://online.datcu.coop/ofxserver/ofxsrvr.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:42:19","lastsslvalidation":"2015-07-02 22:42:19","profile":{"-addr1":"PO Box 827","-city":"Denton","-state":"TX","-postalcode":"76202","-country":"USA","-csphone":"1-866-387-8585","-url":"http://www.datcu.org","-email":"ofx@datcu.org","-signonmsgset":"true","-bankmsgset":"true","-emailmsgset":"true"}},{"id":"683","name":"Denver Community Federal Credit Union","fid":"10524","org":"Denver Community FCU","url":"https://pccu.dcfcu.coop/ofx/ofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-01-23 22:13:56","lastsslvalidation":"2013-01-23 22:13:56","profile":{"-addr1":"1075 Acoma Street","-city":"Denver","-state":"CO","-postalcode":"80204","-country":"USA","-csphone":"3035731170","-url":"http://www.dcfcu.coop","-email":"memberservices@dcfcu.coop","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"684","name":"Discover Platinum","fid":"7102","org":"Discover Financial Services","url":"https://ofx.discovercard.com/","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-22 21:52:45","lastsslvalidation":"2016-01-22 21:55:24","profile":{"-addr1":"2500 Lake Cook Road","-city":"Riverwoods","-state":"IL","-postalcode":"60015","-country":"USA","-csphone":"1-800-DISCOVER","-tsphone":"1-800-DISCOVER","-url":"http://www.discovercard.com","-email":"websupport@discovercard.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"685","name":"EAB","fid":"6505","org":"ISC","url":"https://www.oasis.cfree.com/fip/genesis/prod/06505.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:49:38","lastsslvalidation":"2015-07-02 22:49:37","profile":{"-addr1":"Electronic Banking Dept 2839","-addr2":"1 EAB Plaze","-city":"Uniondale","-state":"NY","-postalcode":"11555","-country":"USA","-url":"http://www.eab.com/","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"686","name":"FAA Credit Union","fid":"114","org":"FAA Credit Union","url":"https://flightline.faaecu.org/ofx/ofx.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-22 21:52:47","lastsslvalidation":"2016-01-22 21:55:25","profile":{"-addr1":"P.O. Box 26406","-city":"Oklahoma City","-state":"OK","-postalcode":"73126","-country":"USA","-csphone":"405-682-1990","-url":"https://flightline.faaecu.org","-email":"info@faaecu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"687","name":"Fairwinds Credit Union","fid":"4842","org":"OSI 2","url":"https://OFX.opensolutionsTOC.com/eftxweb/access.ofx","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-07-31 20:56:22","lastsslvalidation":"2015-07-02 22:53:05","profile":{"-addr1":"3087 N Alafaya Trail","-city":"Orlando","-state":"FL","-postalcode":"32826","-country":"USA","-csphone":"407-277-6030","-tsphone":"407-277-6030","-url":"http://www.fairwinds.org","-email":"rharrington@fairwinds.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"688","name":"FedChoice FCU","fid":"254074785","org":"FEDCHOICE","url":"https://ofx.fedchoice.org/ofxserver/ofxsrvr.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-05-19 22:10:56","lastsslvalidation":"2012-05-19 22:10:53","profile":{"-addr1":"10001 Willowdale Rd.","-city":"Lanham","-state":"MD","-postalcode":"20706","-country":"USA","-csphone":"301 699 6151","-tsphone":"301 699 6900","-url":"www.fedchoice.org","-email":"financialadvisorycenter@fedchoice.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"689","name":"First Clearing, LLC","fid":"10033","org":"First Clearing, LLC","url":"https://pfmpw.wachovia.com/cgi-forte/fortecgi?servicename=ofxbrk&pagename=PFM","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-10-02 22:15:22","lastsslvalidation":"2013-02-04 22:20:09"},{"id":"690","name":"First Citizens","fid":"1849","org":"First Citizens","url":"https://www.oasis.cfree.com/fip/genesis/prod/01849.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:58:00","lastsslvalidation":"2015-07-02 22:58:00","profile":{"-addr1":"P.O. Box 29","-city":"Columbia","-state":"SC","-postalcode":"29202","-country":"USA","-url":"www.firstcitizensonline.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"691","name":"First Hawaiian Bank","fid":"3501","org":"BancWest Corp","url":"https://olbp.fhb.com/ofx0001/ofx_isapi.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:03:06","lastsslvalidation":"2015-11-11 05:51:11","profile":{"-addr1":"999 Bishop Street","-city":"Honolulu","-state":"HI","-postalcode":"96813","-country":"USA","-csphone":"1-888-844-4444","-tsphone":"1-888-844-4444","-url":"http://www.fhb.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true"}},{"id":"692","name":"First National Bank of St. Louis","fid":"162","org":"81004601","url":"https://ofx.centralbancompany.com/ofxserver/ofxsrvr.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:03:15","lastsslvalidation":"2015-07-02 23:03:10"},{"id":"693","name":"First Interstate Bank","fid":"092901683","org":"FIB","url":"https://ofx.firstinterstatebank.com/OFXServer/ofxsrvr.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-11-27 01:47:36","lastsslvalidation":"2015-07-02 23:03:08","profile":{"-addr1":"401 North 31st Street","-city":"Billings","-state":"MT","-postalcode":"59116","-country":"USA","-csphone":"888-752-3332","-tsphone":"888-752-3332","-url":"www.FirstInterstateBank.com","-email":"pcbank@fib.com","-signonmsgset":"true","-bankmsgset":"true","-emailmsgset":"true"}},{"id":"694","name":"Goldman Sachs","fid":"1234","org":"gs.com","brokerid":"gs.com","url":"https://portfolio-ofx.gs.com:446/ofx/ofx.eftx","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-07-02 23:11:09","profile":{"-addr1":"101 Montgomery Street","-city":"San Francisco","-state":"CA","-postalcode":"94104","-country":"USA","-csphone":"(212)344-2000","-tsphone":"(212)344-2000","-url":"WWW.SCHWAB.COM","-email":"help@gs.com","-signonmsgset":"true","-invstmtmsgset":"true"}},{"id":"695","name":"Hudson Valley FCU","fid":"10767","org":"Hudson Valley FCU","url":"https://internetbanking.hvfcu.org/ofx/ofx.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:14:28","lastsslvalidation":"2015-07-02 23:14:28","profile":{"-addr1":"159 Barnegat Road","-city":"Poughkeepsie","-state":"NY","-postalcode":"12533","-country":"USA","-csphone":"800-468-3011","-url":"https://www.hvfcu.org","-email":"info@hvfcu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"696","name":"IBM Southeast Employees Federal Credit Union","fid":"1779","org":"IBM Southeast EFCU","url":"https://rb.ibmsecu.org/ofx/ofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2014-10-05 22:58:37","lastsslvalidation":"2014-10-05 22:58:36","profile":{"-addr1":"790 Park of Commerce Blvd","-city":"Boca Raton","-state":"FL","-postalcode":"33487","-country":"USA","-csphone":"8008735100","-url":"https://rb.ibmsecu.org","-email":"ktobias@ibmsecu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"697","name":"Insight CU","fid":"10764","org":"Insight Credit Union","url":"https://secure.insightcreditunion.com/ofx/ofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-09-20 20:41:03","lastsslvalidation":"2013-03-26 22:24:39","profile":{"-addr1":"480 S Keller Rd","-city":"Orlando","-state":"FL","-postalcode":"32810","-country":"USA","-csphone":"407-426-6000","-url":"https://insightcreditunion.com","-email":"moneycoach@insightcreditunion.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"698","name":"Janney Montgomery Scott LLC","fid":"11326","org":"AFS","brokerid":"https://jmsofx.automat","url":"https://jmsofx.automatedfinancial.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:16:09","lastsslvalidation":"2016-01-04 12:05:47","profile":{"-addr1":"50 Broadway","-city":"New York","-state":"NY","-postalcode":"10004","-country":"USA","-url":"https://jmsofx.automatedfinancial.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"699","name":"JSC Federal Credit Union","fid":"10491","org":"JSC Federal Credit Union","url":"https://starpclegacy.jscfcu.org/ofx/ofx.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-11-30 22:03:51","lastsslvalidation":"2016-01-23 12:40:45","profile":{"-addr1":"1330 Gemini","-city":"Houston","-state":"TX","-postalcode":"77058","-country":"USA","-csphone":"281-488-7070","-url":"http://www.jscfcu.org","-email":"webhelp@jscfcu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"700","name":"J.P. Morgan","fid":"4701","org":"ISC","url":"https://www.oasis.cfree.com/fip/genesis/prod/04701.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:16:01","lastsslvalidation":"2015-07-02 23:16:01","profile":{"-addr1":"902 Market Street, 7th floor","-city":"Wilmington","-state":"DE","-postalcode":"19801","-country":"USA","-url":"http://www.jpmorgan.com/","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"701","name":"J.P. Morgan Clearing Corp.","fid":"7315","org":"GCS","brokerid":"https://ofxpcs.toolkit","url":"https://ofxgcs.toolkit.clearco.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:16:05","lastsslvalidation":"2015-07-02 23:16:05","profile":{"-addr1":"50 broadway","-city":"New York","-state":"NY","-postalcode":"10004","-country":"USA","-url":"https://ofxgcs.toolkit.clearco.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"702","name":"M & T Bank","fid":"2601","org":"ISC","url":"https://www.oasis.cfree.com/fip/genesis/prod/02601.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-11-19 02:06:35","lastsslvalidation":"2015-11-26 05:22:45","profile":{"-addr1":"P.O. Box 4627","-city":"Buffalo","-state":"NY","-postalcode":"142409915","-country":"USA","-url":"http://www.MandTBank.com/","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"703","name":"Marquette Banks","fid":"1301","org":"ISC","url":"https://www.oasis.cfree.com/fip/genesis/prod/01301.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-11-11 13:54:02","lastsslvalidation":"2015-07-02 23:19:43","profile":{"-addr1":"P.O. Box 1000","-city":"Minneapolis","-state":"MN","-postalcode":"554801000","-country":"USA","-url":"http://www.marquette.com/","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"704","name":"Mercer","fid":"8007527525","org":"PutnamDefinedContributions","url":"https://ofx.mercerhrs.com/eftxweb/access.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-11-12 01:59:29","lastsslvalidation":"2015-07-02 23:21:29","profile":{"-addr1":"Investors Way","-city":"Norwood","-state":"MA","-postalcode":"02062","-country":"USA","-csphone":"(800) 926 9225","-tsphone":"(800) 926 9225","-url":"https://ofx.mercerhrs.com/eftxweb/access.ofx","-email":"2","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"705","name":"Merrill Lynch Online Payment","fid":"7301","org":"ISC","url":"https://www.oasis.cfree.com/fip/genesis/prod/07301.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-19 13:19:59","lastsslvalidation":"2016-01-14 01:19:28","profile":{"-addr1":"3 Independence Way","-city":"Princeton","-state":"NJ","-postalcode":"08540","-country":"USA","-url":"http://www.mlol.ml.com/","-signonmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"706","name":"Missoula Federal Credit Union","fid":"5097","org":"Missoula Federal Credit Union","url":"https://secure.missoulafcu.org/ofx/ofx.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:23:16","lastsslvalidation":"2015-07-02 23:23:16","profile":{"-addr1":"3600 Brooks St","-city":"Missoula","-state":"MT","-postalcode":"59801","-country":"USA","-csphone":"(406)523-3300","-url":"https://secure.missoulafcu.org","-email":"memberservice@missoulafcu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"707","name":"Morgan Stanley (Smith Barney)","fid":"5207","org":"Smithbarney.com","brokerid":"smithbarney.com","url":"https://ofx.smithbarney.com/app-bin/ofx/servlets/access.ofx","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-07-20 22:29:23","lastsslvalidation":"2013-07-20 22:29:20","profile":{"-addr1":"250 West Str","-city":"New York","-state":"NY","-postalcode":"10005","-country":"USA","-csphone":"1-212-723-2898","-tsphone":"1-212-723-2898","-url":"http://ofx.smithbarney.com","-email":"alex_shnir@smb.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"708","name":"Nevada State Bank - OLD","fid":"5401","org":"ISC","url":"https://www.oasis.cfree.com/fip/genesis/prod/05401.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-11-30 03:35:51","lastsslvalidation":"2015-12-27 20:49:37","profile":{"-addr1":"Online Banking Support","-addr2":"PO Box 30709","-city":"Salt Lake City","-state":"UT","-postalcode":"841309976","-country":"USA","-url":"http://www.zionsbank.com/","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"709","name":"New England Federal Credit Union","fid":"2104","org":"New England Federal Credit Union","url":"https://pcaccess.nefcu.com/ofx/ofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-01-03 22:22:14","lastsslvalidation":"2012-01-03 22:22:12","profile":{"-addr1":"141 Harvest Lane","-city":"Williston","-state":"VT","-postalcode":"05495","-country":"USA","-csphone":"800 400-8790","-url":"http://www.nefcu.com","-email":"online@nefcu.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"710","name":"Norwest","fid":"4601","org":"ISC","url":"https://www.oasis.cfree.com/fip/genesis/prod/04601.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-09-11 11:21:38","lastsslvalidation":"2015-09-11 12:26:21","profile":{"-addr1":"420 Montgomery Street","-city":"San Francisco","-state":"CA","-postalcode":"94104","-country":"USA","-url":"http://www.wellsfargo.com/","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"711","name":"Oppenheimer & Co. Inc.","fid":"125","org":"Oppenheimer","brokerid":"Oppenheimer","url":"https://ofx.opco.com/eftxweb/access.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:33:39","lastsslvalidation":"2015-07-02 23:33:35","profile":{"-addr1":"125 Broad Street","-city":"New York","-state":"NY","-postalcode":"10004","-country":"USA","-csphone":"1-800-555-1212","-tsphone":"1-800-555-1212","-url":"http://www.opco.com","-email":"support@opco.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"712","name":"Oregon College Savings Plan","fid":"51498","org":"tiaaoregon","brokerid":"tiaa-cref.org","url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=b1908000027141704061413","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-10-15 08:51:17","lastsslvalidation":"2016-01-22 21:55:27","profile":{"-addr1":"PO Box 55914","-city":"Boston","-state":"MA","-postalcode":"02205-5914","-country":"USA","-url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=b1908000027141704061413","-signonmsgset":"true","-invstmtmsgset":"true"}},{"id":"713","name":"RBC Dain Rauscher","fid":"8035","org":"RBC Dain Rauscher","brokerid":"RBCDain.com","url":"https://ofx.rbcdain.com/","ofxfail":"1","sslfail":"0","lastofxvalidation":"2014-04-29 22:48:22","lastsslvalidation":"2015-07-02 23:40:20","profile":{"-addr1":"RBC Plaza","-addr2":"60 South 6th Street","-city":"Minneapolis","-state":"MN","-postalcode":"55402","-country":"USA","-csphone":"888.281.4094","-tsphone":"888.281.4094","-url":"http://www.rbcwm-usa.com","-email":"connectdesk@rbc.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"714","name":"Robert W. Baird & Co.","fid":"1109","org":"Robert W. Baird & Co.","brokerid":"rwbaird.com","url":"https://ofx.rwbaird.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:43:36","lastsslvalidation":"2015-07-02 23:43:35","profile":{"-addr1":"777 East Wisconsin Avenue","-city":"Milwaukee","-state":"WI","-postalcode":"53202","-country":"USA","-csphone":"414.765.3500","-tsphone":"414.765.3500","-url":"http://www.rwbaird.com","-email":"info@rwbaird.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"715","name":"Sears Card","fid":"26810","org":"CITIGROUP","url":"https://secureofx.bankhost.com/tuxofx/cgi-bin/cgi_chip","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-03-06 22:36:20","lastsslvalidation":"2013-06-11 22:45:23","profile":{"-addr1":"8787 Baypine Road","-city":"Jacksonville","-state":"FL","-postalcode":"32256","-country":"USA","-url":"www.citicards.com","-signonmsgset":"true","-creditcardmsgset":"true"}},{"id":"716","name":"South Trust Bank","fid":"6101","org":"ISC","url":"https://www.oasis.cfree.com/fip/genesis/prod/06101.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-09-11 13:02:12","lastsslvalidation":"2015-09-11 12:54:04","profile":{"-addr1":"South Trust Online Banking","-addr2":"P.O. Box 2554","-city":"Birmingham","-state":"AL","-postalcode":"35290","-country":"USA","-url":"http://www.southtrust.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"717","name":"Standard Federal Bank","fid":"6507","org":"ISC","url":"https://www.oasis.cfree.com/fip/genesis/prod/06507.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:58:33","lastsslvalidation":"2015-07-24 23:39:15","profile":{"-addr1":"79 W. Monroe, Suite 302","-addr2":"Online Banking Customer Service","-city":"Chicago","-state":"IL","-postalcode":"60603","-country":"USA","-url":"http://www.standardfederalbank.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"718","name":"United California Bank","fid":"2701","org":"ISC","url":"https://www.oasis.cfree.com/fip/genesis/prod/02701.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-09-11 12:56:13","lastsslvalidation":"2015-08-06 04:23:24","profile":{"-addr1":"P.O. Box 3567","-city":"Los Angeles","-state":"CA","-postalcode":"900519738","-country":"USA","-url":"http://www.sanwabank.com/","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"719","name":"United Federal CU - PowerLink","fid":"1908","org":"United Federal Credit Union","url":"https://remotebanking.unitedfcu.com/ofx/ofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2011-09-30 22:30:11","lastsslvalidation":"2012-01-03 22:30:06","profile":{"-addr1":"2807 S State St","-city":"St Joseph","-state":"MI","-postalcode":"49085","-country":"USA","-csphone":"888-982-1400","-url":"http://www.unitedfcu.com","-email":"frfcu@unitedfcu.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"720","name":"VALIC","fid":"77019","org":"valic.com","brokerid":"valic.com","url":"https://ofx.valic.com/eftxweb/access.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-22 21:52:49","lastsslvalidation":"2015-07-03 00:09:35","profile":{"-addr1":"2929 Allen Parkway","-city":"Houston","-state":"TX","-postalcode":"77019","-country":"USA","-csphone":"800-448-2542","-tsphone":"800-448-2542","-url":"http://www.valic.com","-email":"ofxsupport@valic.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"721","name":"Van Kampen Funds, Inc.","fid":"3625","org":"Van Kampen Funds, Inc.","url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=9210013100012150413","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-03 00:09:36","lastsslvalidation":"2016-01-17 19:19:04","profile":{"-addr1":"1 Parkview Plaza","-city":"Oakbrook Terrace","-state":"IL","-postalcode":"60181","-country":"USA","-url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=9210013100012150413","-signonmsgset":"true","-invstmtmsgset":"true"}},{"id":"722","name":"Vanguard Group","fid":"1358","org":"The Vanguard Group","brokerid":"vanguard.com","url":"https://vesnc.vanguard.com/us/OfxProfileServlet","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-22 21:52:52","lastsslvalidation":"2016-01-25 16:18:51","profile":{"-addr1":"P.O. Box 1110","-city":"Valley Forge","-state":"PA","-postalcode":"19482-1110","-country":"USA","-url":"https://vesnc.vanguard.com/us/OfxDirectConnectServlet","-signonmsgset":"true","-invstmtmsgset":"true","-emailmsgset":"true","-notes":"Automatically imports 12 months of transactions"}},{"id":"723","name":"Velocity Credit Union","fid":"9909","org":"Velocity Credit Union","url":"https://rbserver.velocitycu.com/ofx/ofx.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-03 00:09:39","lastsslvalidation":"2016-01-21 08:05:04","profile":{"-addr1":"P.O. Box 1089","-city":"Austin","-state":"TX","-postalcode":"78767-1089","-country":"USA","-csphone":"512-469-7000","-url":"https://www.velocitycu.com","-email":"msc@velocitycu.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"724","name":"Waddell & Reed - Ivy Funds","fid":"49623","org":"waddell","brokerid":"waddell.com","url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=722000303041111","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-03 00:12:51","lastsslvalidation":"2016-01-22 21:55:29","profile":{"-addr1":"816 Broadway","-city":"Kansas City","-state":"MO","-postalcode":"64105","-country":"USA","-url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=722000303041111","-signonmsgset":"true","-invstmtmsgset":"true"}},{"id":"725","name":"Umpqua Bank","fid":"1001","org":"Umpqua","url":"https://ofx.umpquabank.com/ofx/process.ofx","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-03-14 23:56:10","lastsslvalidation":"2015-03-14 23:56:02","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"726","name":"Discover Bank","fid":"12610","org":"Discover Bank","url":"https://ofx.discovercard.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-22 21:52:53","lastsslvalidation":"2016-01-25 13:14:17","profile":{"-addr1":"2500 Lake Cook Road","-city":"Riverwoods","-state":"IL","-postalcode":"60015","-country":"USA","-csphone":"1-800-DISCOVER","-tsphone":"1-800-DISCOVER","-url":"https://www.discover.com","-email":"websupport@discoverbank.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"727","name":"Elevations Credit Union","fid":"1001","org":"uocfcu","url":"https://ofx.elevationscu.com/scripts/serverext.dll","ofxfail":"2","sslfail":"4","lastofxvalidation":"2011-11-09 22:12:37","lastsslvalidation":"2011-11-09 22:12:36","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"728","name":"Kitsap Community Credit Union","fid":"325180223","org":"Kitsap Community Federal Credit","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-23 02:46:53","lastsslvalidation":"2015-07-02 23:17:54","profile":{"-addr1":"155 Washington Ave","-city":"Bremerton","-state":"WA","-postalcode":"98337","-country":"USA","-csphone":"800-422-5852","-tsphone":"800-422-5852","-url":"www.kitsapcuhb.org","-email":"2","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"729","name":"Charles Schwab Retirement","fid":"1234","org":"SchwabRPS","url":"https://ofx.schwab.com/cgi_dev/ofx_server","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-22 21:52:57","lastsslvalidation":"2016-01-22 21:55:32","profile":{"-addr1":"101 Montgomery Street","-city":"San Francisco","-state":"CA","-postalcode":"94104","-country":"USA","-csphone":"(212)344-2000","-tsphone":"(212)344-2000","-url":"WWW.SCHWAB.COM","-email":"help@gs.com","-signonmsgset":"true","-invstmtmsgset":"true"}},{"id":"730","name":"Charles Schwab Retirement Plan Services","fid":"1234","org":"SchwabRPS","brokerid":"SchwabRPS.dv","url":"https://ofx.schwab.com/cgi_dev/ofx_server","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-22 21:52:59","lastsslvalidation":"2016-01-22 21:55:34","profile":{"-addr1":"101 Montgomery Street","-city":"San Francisco","-state":"CA","-postalcode":"94104","-country":"USA","-csphone":"(212)344-2000","-tsphone":"(212)344-2000","-url":"WWW.SCHWAB.COM","-email":"help@gs.com","-signonmsgset":"true","-invstmtmsgset":"true"}},{"id":"731","name":"First Tech Federal Credit Union","fid":"3169","org":"First Tech Federal Credit Union","url":"https://ofx.firsttechfed.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:05:28","lastsslvalidation":"2016-01-11 19:07:41","profile":{"-addr1":"3408 Hillview Ave","-city":"Palo Alto","-state":"CA","-postalcode":"94304","-country":"USA","-csphone":"877.233.4766","-tsphone":"877.233.4766","-url":"https://www.firsttechfed.com","-email":"email@firsttechfed.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"732","name":"Affinity Plus Federal Credit Union","fid":"75","org":"Affinity Plus FCU","url":"https://hb.affinityplus.org/ofx/ofx.dll","ofxfail":"3","sslfail":"0","lastofxvalidation":"2015-01-07 22:01:49","lastsslvalidation":"2015-07-02 22:04:18","profile":{"-addr1":"175 West Lafayette Rd","-city":"St. Paul","-state":"MN","-postalcode":"55107","-country":"USA","-csphone":"651-291-3700","-url":"https://hb.affinityplus.org","-email":"affinityplus@affinityplus.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"733","name":"Bank of George","fid":"122402366","org":"122402366","url":"https://ofx.internet-ebanking.com/CCOFXServer/servlet/TP_OFX_Controller","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-12-26 22:06:07","lastsslvalidation":"2013-01-06 22:06:47","profile":{"-addr1":"9115 W. Russell Road","-city":"Las Vegas","-state":"NV","-postalcode":"89148","-country":"USA","-csphone":"(702) 851-4200","-tsphone":"(702) 851-4200","-url":"http://www.bankofgeorge.com","-email":"customerservice@bankofgeorge.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"734","name":"Franklin Templeton Investments","fid":"9444","org":"franklintempleton.com","brokerid":"franklintempleton.com","url":"https://ofx.franklintempleton.com/eftxweb/access.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-10-01 07:57:27","lastsslvalidation":"2016-01-14 01:45:46","profile":{"-addr1":"P.O. Box 997152","-city":"Sacramento","-state":"CA","-postalcode":"95670-7313","-country":"USA","-csphone":"1-800-632-2301","-tsphone":"1-800-632-2301","-url":"www.franklintempleton.com","-email":"shareholderservices@frk.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"735","name":"ING Institutional Plan Services ","fid":"1289","org":"ing-usa.com","url":"https://ofx.ingplans.com/ofx/Server","ofxfail":"3","sslfail":"4","lastofxvalidation":"2014-08-29 22:27:37","lastsslvalidation":"2014-08-29 22:27:37","profile":{"-addr1":"One Orange Way","-city":"Windsor","-state":"CT","-postalcode":"06095","-country":"USA","-csphone":"plan info line","-tsphone":"plan info line","-url":"http://foremployers.voya.com/retirement-plans/institutional-plans","-email":"plan info line","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"736","name":"Sterne Agee","fid":"2170","org":"AFS","brokerid":"sterneagee.com","url":"https://salofx.automatedfinancial.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-12-22 09:10:32","lastsslvalidation":"2015-07-02 23:58:35","profile":{"-addr1":"50 Broadway","-city":"New York","-state":"NY","-postalcode":"10004","-country":"USA","-url":"https://salofx.automatedfinancial.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"737","name":"Wells Fargo Advisors","fid":"12748","org":"WF","brokerid":"Wells Fargo Advisors","url":"https://ofxdc.wellsfargo.com/ofxbrokerage/process.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-25 13:41:49","lastsslvalidation":"2016-01-22 21:55:37","profile":{"-addr1":"P.O. Box 6808","-city":"Concord","-state":"CA","-postalcode":"94524","-country":"USA","-csphone":"1-800-956-4442","-tsphone":"1-800-956-4442","-url":"https://online.wellsfargo.com/","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"738","name":"Community 1st Credit Union","fid":"325082017","org":"Community 1st Credit Union","url":"https://ib.comm1stcu.org/scripts/isaofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2012-08-21 22:07:20","lastsslvalidation":"2012-07-31 22:06:07","profile":{"-addr1":"14625 15th Avenue NE","-city":"Shoreline","-state":"WA","-postalcode":"98155","-country":"USA","-csphone":"1-800-247-7328","-tsphone":"1-800-247-7328","-url":"https://myc1cu.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true"}},{"id":"739","name":"American Century Investments","brokerid":"americancentury.com","url":"https://ofx.americancentury.com/","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:09:15","lastsslvalidation":"2015-07-02 22:09:15","profile":{"-addr1":"P.O. Box 173375","-city":"Denver","-state":"CO","-postalcode":"80217","-country":"USA","-csphone":"816.345.7645","-tsphone":"816.345.7645","-url":"https://ofx3.financialtrans.com/tf/OFXServer?tx=OFXController&cz=702110804131918&cl=50900132018","-email":"service@americancentury.com","-signonmsgset":"true","-bankmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"740","name":"J.P. Morgan Private Banking","fid":"0417","org":"jpmorgan.com","brokerid":"jpmorgan.com","url":"https://ofx.jpmorgan.com/jpmredirector","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-24 21:20:44","lastsslvalidation":"2015-07-02 23:16:05","profile":{"-addr1":"522 5th Ave","-addr2":"null","-city":"New York","-state":"NY","-postalcode":"10036","-country":"USA","-url":"http://localhost:9080/ofx/JPMWebRedirector","-email":"jpmorgan2@jpmorgan.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"741","name":"Northwest Community CU","fid":"1948","org":"Cavion","url":"https://ofx.lanxtra.com/ofx/servlet/Teller","ofxfail":"0","sslfail":"4","lastofxvalidation":"2015-07-02 23:30:15","lastsslvalidation":"2013-08-19 22:37:01","profile":{"-addr1":"P.O BOX 70225","-city":"Eugene","-state":"OR","-postalcode":"97401","-country":"USA","-csphone":"8004529515","-tsphone":"8004529515","-url":"http://www.nwcu.com","-email":"callcenter@nwcu.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"742","name":"North Carolina State Employees Credit Union","fid":"1001","org":"SECU","url":"https://onlineaccess.ncsecu.org/secuofx/secu.ofx ","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-21 07:59:27","lastsslvalidation":"2015-07-02 23:28:24","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"743","name":"International Bank of Commerce","fid":"1001","org":"IBC","url":"https://ibcbankonline2.ibc.com/scripts/serverext.dll","ofxfail":"0","sslfail":"4","lastofxvalidation":"2016-01-24 08:18:05","lastsslvalidation":"2015-10-25 21:17:32","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"744","name":"RaboBank America","fid":"11540","org":"RBB","url":"https://ofx.rabobankamerica.com/ofx/process.ofx","ofxfail":"3","sslfail":"4","lastofxvalidation":"2015-05-28 23:33:45","lastsslvalidation":"2015-05-29 07:31:05","profile":{"-addr1":"PO Box 6002","-city":"Arroyo Grande","-state":"CA","-postalcode":"93420","-country":"USA","-csphone":"800-959-2399","-tsphone":"800-959-2399","-url":"http://www.rabobankamerica.com","-email":"ebanking@rabobank.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"745","name":"Hughes Federal Credit Union","fid":"1951","org":"Cavion","url":"https://ofx.lanxtra.com/ofx/servlet/Teller","ofxfail":"0","sslfail":"4","lastofxvalidation":"2016-01-11 11:46:29","lastsslvalidation":"2013-08-19 22:23:31","profile":{"-addr1":"P.O. Box 11900","-city":"Tucson","-state":"AZ","-postalcode":"85734","-country":"USA","-csphone":"(520) 794-8341","-tsphone":"(520) 794-8341","-url":"http://www.hughesfcu.org","-email":"xxxxx","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"746","name":"Apple FCU","fid":"256078514","org":"DI","brokerid":"md:1023","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:19:22","lastsslvalidation":"2015-07-02 22:19:21","profile":{"-addr1":"4029 Ridge Top Road","-city":"Fairfax","-state":"VA","-postalcode":"22030","-country":"USA","-csphone":"800-666-7996","-tsphone":"800-666-7996","-url":"https://www.applefcu.org","-email":"2","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"747","name":"Chemical Bank","fid":"072410013","org":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:30:22","lastsslvalidation":"2015-07-02 22:30:21","profile":{"-addr1":"333 E. Main Street","-city":"Midland","-state":"MI","-postalcode":"48640","-country":"USA","-csphone":"800-633-3800","-tsphone":"800-633-3800","-url":"www.chemicalbankmi.com","-email":"ebanking@chemicalbankmi.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"748","name":"Local Government Federal Credit Union","fid":"1001","org":"SECU","url":"https://onlineaccess.ncsecu.org/lgfcuofx/lgfcu.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:19:36","lastsslvalidation":"2015-07-02 23:19:35","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"749","name":"Wells Fargo Bank","fid":"3000","org":"WF","url":"https://ofxdc.wellsfargo.com/ofx/process.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-22 21:53:24","lastsslvalidation":"2016-01-22 21:55:43","profile":{"-addr1":"P.O. Box 6808","-city":"Concord","-state":"CA","-postalcode":"94524","-country":"USA","-csphone":"1-800-956-4442","-tsphone":"1-800-956-4442","-url":"https://online.wellsfargo.com/","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"750","name":"Schwab Retirement Plan Services","fid":"11811","org":"The 401k Company","brokerid":"www.401kaccess.com","url":"https://ofx1.401kaccess.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-14 09:10:26","lastsslvalidation":"2015-08-09 06:57:40","profile":{"-addr1":"98 San Jacinto Blvd.","-addr2":"Suite 1100","-city":"Austin","-state":"TX","-postalcode":"78701","-country":"USA","-csphone":"(800) 777-4015","-tsphone":"(800) 777-4015","-url":"http://www.the401k.com","-email":"partserv@the401k.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"751","name":"Southern Community Bank and Trust (SCB&T)","fid":"053112097","org":"MOneFortyEight","url":"https://ofx1.evault.ws/OFXServer/ofxsrvr.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:58:30","lastsslvalidation":"2015-07-02 23:58:30","profile":{"-addr1":"4605 Country Club Road","-city":"Winston-Salem","-state":"NC","-postalcode":"27104","-country":"USA","-csphone":"(888) 768-2666","-tsphone":"(888) 768-2666","-url":"http://www.smallenoughtocare.com","-email":"noreply@smallenoughtocare.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"752","name":"Elevations Credit Union IB WC-DC","fid":"307074580","org":"uofcfcu","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx ","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:51:25","lastsslvalidation":"2015-07-02 22:51:24","profile":{"-addr1":"Po Box 9004","-city":"Boulder","-state":"CO","-postalcode":"80301","-country":"USA","-csphone":"303-443-4672","-tsphone":"303-443-4672","-url":"www.elevationscu.com","-email":"ecuservice@elevationscu.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"753","name":"Credit Suisse Securities USA LLC","fid":"001","org":"Credit Suisse Securities USA LLC","brokerid":"credit-suisse.com","url":"https://ofx.netxclient.com/cgi/OFXNetx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:40:39","lastsslvalidation":"2015-07-02 22:40:39","profile":{"-addr1":"ELEVEN MADISON AVENUE","-city":"New York","-state":"NY","-postalcode":"10010","-country":"USA","-csphone":"1-877-355-1818","-tsphone":"877-355-1818","-url":"http://www.credit-suisse.com/pbclientview","-email":"pb.clientview@credit-suisse.com","-signonmsgset":"true","-invstmtmsgset":"true"}},{"id":"754","name":"North Country FCU","fid":"211691004","org":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:28:29","lastsslvalidation":"2015-07-02 23:28:28","profile":{"-addr1":"69 Swift St","-addr2":"Ste 100","-city":"S. Burlington","-state":"VT","-postalcode":"05403","-country":"USA","-csphone":"800-660-3258","-tsphone":"800-660-3258","-url":"www.northcountry.org","-email":"memberservices@northcountry.org","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"755","name":"South Carolina Bank and Trust","fid":"053200983","org":"MZeroOneZeroSCBT","url":"https://ofx1.evault.ws/ofxserver/ofxsrvr.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-11-29 09:01:58","lastsslvalidation":"2015-07-02 23:56:53","profile":{"-addr1":"PO BOX 1287","-city":"Orangeburg","-state":"NC","-postalcode":"29116","-country":"USA","-csphone":"1-877-277-2185","-url":"http://www.scbtonline.com","-email":"noreply@scbtonline.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"756","name":"Wings Financial","fid":"296076152","org":"DI","brokerid":"102","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-22 21:53:26","lastsslvalidation":"2016-01-22 21:55:44","profile":{"-addr1":"14985 Glazier Avenue","-city":"Apple Valley","-state":"MN","-postalcode":"55124","-country":"USA","-csphone":"800-692-2274 x8 4357","-tsphone":"800-692-2274 x8 4357","-url":"www.wingsfinancial.com","-email":"helpdesk@wingsfinancial.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"757","name":"Haverhill Bank","fid":"93","org":"orcc","url":"https://www20.onlinebank.com/OROFX16Listener","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:11:10","lastsslvalidation":"2015-07-02 23:11:10","profile":{"-addr1":"180 Merrimack Street","-addr2":"P.O. Box 1656","-city":"Haverhill","-state":"MA","-postalcode":"01830","-country":"USA","-csphone":"(800) 686-2831","-tsphone":"(800) 686-2831","-url":"http://www.haverhillbank.com","-email":"ebanking@haverhillbank.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"758","name":"Mission Federal Credit Union","fid":"1001","org":"mission","brokerid":"102","url":"https://missionlink.missionfcu.org/scripts/serverext.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-04-23 23:18:18","lastsslvalidation":"2015-04-23 23:18:17","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"759","name":"Southwest Missouri Bank","fid":"101203641","org":"Jack Henry","url":"https://directline.netteller.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-19 01:22:07","lastsslvalidation":"2015-07-02 23:58:31"},{"id":"760","name":"Cambridge Savings Bank","fid":"211371120","org":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:28:11","lastsslvalidation":"2015-07-02 22:28:10","profile":{"-addr1":"1374 Massachusetts Ave","-city":"Cambridge","-state":"MA","-postalcode":"02138-3083","-country":"USA","-csphone":"888-418-5626","-tsphone":"888-418-5626","-url":"www.cambridgesavings.com","-email":"info@csb.usa.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"761","name":"NetxClient UAT","fid":"1023","org":"NetxClient","brokerid":"www.netxclient.com","url":"https://uat-ofx.netxclient.inautix.com/cgi/OFXNetx","ofxfail":"3","sslfail":"0","lastofxvalidation":"2014-02-23 22:43:38","lastsslvalidation":"2015-07-02 23:26:45","profile":{"-addr1":"One Pershing Plaza","-city":"Jersey City","-state":"NJ","-postalcode":"07399","-country":"USA","-csphone":"201-413-2162","-tsphone":"201-413-2162","-url":"http://www.netxclient.com","-email":"mgutierrez@pershing.com","-signonmsgset":"true","-invstmtmsgset":"true"}},{"id":"762","name":"bankfinancial","fid":"271972899","org":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:24:35","lastsslvalidation":"2015-07-02 22:24:34","profile":{"-addr1":"21110 S. Western Ave.","-city":"Olympia Fields","-state":"IL","-postalcode":"60461","-country":"USA","-csphone":"800-894-6900","-tsphone":"800-894-6900","-url":"www.bankfinancial.com","-email":"Please use Phone.","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"763","name":"AXA Equitable","fid":"7199","org":"AXA","brokerid":"AXAonline.com","url":"https://ofx.netxclient.com/cgi/OFXNetx","ofxfail":"3","sslfail":"0","lastofxvalidation":"2014-03-18 22:06:33","lastsslvalidation":"2015-07-02 22:22:37","profile":{"-addr1":"One Pershing Plaza","-city":"Jersey City","-state":"NJ","-postalcode":"07399","-country":"USA","-csphone":"201-413-2162","-tsphone":"201-413-2162","-url":"http://www.netxclient.com","-email":"mgutierrez@pershing.com","-signonmsgset":"true","-invstmtmsgset":"true"}},{"id":"764","name":"Premier America Credit Union","fid":"322283990","org":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:38:42","lastsslvalidation":"2015-07-02 23:38:41","profile":{"-addr1":"19867 Prairie Street","-city":"Chatsworth","-state":"CA","-postalcode":"91311","-country":"USA","-csphone":"800-772-4000","-tsphone":"800-772-4000","-url":"www.premier.org","-email":"info@premier.org","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"765","name":"Bank of America - 5959","fid":"5959","org":"HAN","url":"https://ofx.bankofamerica.com/cgi-forte/fortecgi?servicename=ofx_2-3&pagename=ofx","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-05-03 22:15:33","lastsslvalidation":"2015-05-03 22:15:32","profile":{"-addr1":"Interactive Banking","-addr2":"TX1-854-06-12","-addr3":"P.O. Box 655961","-city":"Dallas","-state":"TX","-postalcode":"75265-9964","-country":"USA","-csphone":"(800) 933-6262","-tsphone":"(800) 933-6262","-url":"http://www.bankofamerica.com","-email":"forte@bankofamerica.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"766","name":"First Command Bank","fid":"188","org":"First Command Bank","url":"https://www19.onlinebank.com/OROFX16Listener","ofxfail":"1","sslfail":"5","lastofxvalidation":"2013-05-31 22:27:01","lastsslvalidation":"2014-08-24 22:18:29","profile":{"-addr1":"4100 South Hulen","-addr2":"Suite 150","-city":"Fort Worth","-state":"TX","-postalcode":"76109","-country":"USA","-csphone":"(888) 763-7600","-tsphone":"(888) 763-7600","-url":"http://www.firstcommandbank.com","-email":"ebd@firstcommandbank.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"767","name":"TIAA-CREF","fid":"041","org":"tiaa-cref.org","brokerid":"tiaa-cref.org","url":"https://ofx.netxclient.com/cgi/OFXNetx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-03 00:02:28","lastsslvalidation":"2015-07-03 00:02:27","profile":{"-addr1":"730 Third Avenue","-city":"New York","-state":"NY","-postalcode":"10017-3206","-country":"USA","-csphone":"800-927-3059","-tsphone":"800-927-3059","-url":"http://www.tiaa-cref.org","-email":"-","-signonmsgset":"true","-invstmtmsgset":"true"}},{"id":"768","name":"Citizens National Bank","fid":"111903151","org":"DI","brokerid":"111903151","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:33:54","lastsslvalidation":"2015-07-02 22:33:54","profile":{"-addr1":"201 W. Main Street","-city":"Henderson","-state":"CA","-postalcode":"75653-1009","-country":"USA","-csphone":"877-566-2621","-tsphone":"877-566-2621","-url":"www.cnbtexas.com","-email":"n/a","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"769","name":"Tower Federal Credit Union","fid":"255077370","org":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-03 00:02:30","lastsslvalidation":"2015-07-03 00:02:29","profile":{"-addr1":"7901 Sandy Spring Road","-city":"Laurel","-state":"MD","-postalcode":"20707-3589","-country":"US","-csphone":"(301)497-7000","-url":"www.towerfcu.org","-email":"2","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"770","name":"First Republic Bank","fid":"321081669","org":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:03:17","lastsslvalidation":"2015-07-02 23:03:16","profile":{"-addr1":"111 Pine Street","-city":"San Francisco","-state":"CA","-postalcode":"94111","-country":"USA","-csphone":"888-372-4891","-tsphone":"888-372-4891","-url":"www.firstrepublic.com","-email":"2","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"771","name":"Texans Credit Union","fid":"-1","org":"TexansCU","url":"https://www.netit.financial-net.com/ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:59:10","lastsslvalidation":"2015-07-02 23:59:10"},{"id":"772","name":"AltaOne","fid":"322274462","org":"AltaOneFCU","url":"https://msconline.altaone.net/scripts/isaofx.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-23 04:00:19","lastsslvalidation":"2016-01-22 21:55:48","profile":{"-addr1":"1250 Drummers Ln.","-city":"Valley Forge","-state":"PA","-postalcode":"19482","-country":"USA","-csphone":"610-687-9400","-tsphone":"610-687-9400","-url":"http://www.users.com","-email":"admin@users.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true"}},{"id":"773","name":"CenterState Bank","fid":"1942","org":"ORCC","url":"https://www20.onlinebank.com/OROFX16Listener","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:28:34","lastsslvalidation":"2015-07-02 22:28:33","profile":{"-addr1":"1101 First Street South","-city":"Winter Haven","-state":"FL","-postalcode":"33880","-country":"USA","-csphone":"800-786-7749","-tsphone":"800-786-7749","-url":"http://www.centerstatebank.com","-email":"estaton@centerstatebank.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"774","name":"5 Star Bank","fid":"307087713","org":"5 Star Bank","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:02:28","lastsslvalidation":"2015-07-02 22:02:27","profile":{"-addr1":"909 N. washington St","-city":"Alexandria","-state":"VA","-postalcode":"22314","-country":"USA","-csphone":"719-574-2777","-tsphone":"719-574-2777","-url":"www.5staronlinebanking.com","-email":"2","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"775","name":"Belmont Savings Bank","fid":"211371764","org":"DI","brokerid":"9460","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:26:14","lastsslvalidation":"2015-07-02 22:26:13","profile":{"-addr1":"2 Leonard Street","-city":"Belmont","-state":"MA","-postalcode":"02478","-country":"USA","-url":"www.belmontsavings.com","-email":"2","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"776","name":"UNIVERSITY & STATE EMPLOYEES CU","fid":"322281691","org":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-03 00:07:45","lastsslvalidation":"2015-07-03 00:07:44","profile":{"-addr1":"10120 Pacific Heights Blvd.","-city":"San Diego","-state":"CA","-postalcode":"92121","-country":"USA","-csphone":"1-866-USE-4-YOU","-tsphone":"1-866-USE-4-YOU","-url":"http://www.usecu.org","-email":"webmaster@usecu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"777","name":"Wells Fargo Bank 2013","fid":"3001","org":"Wells Fargo","url":"https://www.oasis.cfree.com/3001.ofxgp","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-22 21:53:51","lastsslvalidation":"2016-01-22 21:55:49"},{"id":"778","name":"The Golden1 Credit Union","fid":"1001","org":"Golden1","url":"https://homebanking.golden1.com/scripts/serverext.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:59:15","lastsslvalidation":"2016-01-02 00:17:22","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"779","name":"Woodsboro Bank","fid":"7479","org":"JackHenry","brokerid":"102","url":"https://directline.netteller.com/","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-22 21:53:53","lastsslvalidation":"2016-01-22 21:55:51","profile":{"-addr1":"P O Box 36","-addr2":"Woodsboro, MD  21798","-city":"WOODSBORO","-state":"MD","-postalcode":"217980036","-country":"USA","-csphone":"(301) 898-4000","-tsphone":"301-898-4000","-url":"http://www.woodsborobank.com","-email":"customerservice@woodsborobank.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"780","name":"Sandia Laboratory Federal Credit Union","fid":"1001","org":"SLFCU","brokerid":"307083911","url":"https://ofx-prod.slfcu.org/ofx/process.ofx ","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:49:56","lastsslvalidation":"2015-07-02 23:49:56","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"781","name":"Oregon Community Credit Union","fid":"2077","org":"ORCC","url":"https://www20.onlinebank.com/OROFX16Listener","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-24 04:19:40","lastsslvalidation":"2015-07-02 23:33:44","profile":{"-addr1":"PO Box 77002","-city":"Eugene","-state":"OR","-postalcode":"97401-0146","-country":"USA","-csphone":"800-365-1111","-tsphone":"800-365-1111","-url":"http://www.OregonCommunityCU.org","-email":"mpenn@OregonCommunityCU.org","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"782","name":"Advantis Credit Union","fid":"323075097","org":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:04:17","lastsslvalidation":"2015-07-02 22:04:16","profile":{"-addr1":"P.O. BOX 14220","-city":"Portland","-state":"OR","-postalcode":"97293-0220","-country":"USA","-csphone":"503-785-2528 opt 5","-tsphone":"503-785-2528 opt 5","-url":"www.advantiscu.org","-email":"advantiscu@advantiscu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"783","name":"Capital One 360","fid":"031176110","org":"ING DIRECT","url":"https://ofx.capitalone360.com/OFX/ofx.html","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:28:25","lastsslvalidation":"2015-07-02 22:28:24"},{"id":"784","name":"Flagstar Bank","fid":"272471852","org":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:05:34","lastsslvalidation":"2015-07-02 23:05:33","profile":{"-addr1":"301 W. Michigan Ave","-city":"Jackson","-state":"MI","-postalcode":"49201","-country":"USA","-csphone":"800-642-0039","-tsphone":"800-642-0039","-url":"www.flagstar.com","-email":"bank@flagstar.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"785","name":"Arizona State Credit Union","fid":"322172496","org":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:19:25","lastsslvalidation":"2015-07-02 22:19:25","profile":{"-addr1":"1819 W. Monroe St.","-city":"Phoenix","-state":"AZ","-postalcode":"85007","-country":"USA","-csphone":"1-800-671-1098","-tsphone":"1-800-671-1098","-url":"https://www.azstcu.org","-email":"virtualaccess@azstcu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"786","name":"AmegyBank","fid":"1165","org":"292-3","url":"https://pfm.metavante.com/ofx/OFXServlet","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:09:10","lastsslvalidation":"2015-07-02 22:09:09","profile":{"-addr1":"4400 Post Oak Parkway","-city":"Houston","-state":"TX","-postalcode":"77027","-country":"USA","-csphone":"18885018157","-tsphone":"18885018157","-url":"www.amegybank.com","-email":"amegypfm@amegybank.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-interxfermsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"787","name":"Bank of Internet, USA","fid":"122287251","org":"Bank of Internet","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:22:49","lastsslvalidation":"2015-07-02 22:22:48","profile":{"-addr1":"1277 High Bluff Derive #100","-city":"San Diego","-state":"CA","-postalcode":"92191-9000","-country":"USA","-csphone":"858-350-6200","-tsphone":"858-350-6200","-url":"www.mybankinternet.com","-email":"secure@BofI.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"788","name":"Amplify Federal Credit Union","fid":"1","org":"Harland Financial Solutions","url":"https://ezonline.goamplify.com/ofx/ofx.dll","ofxfail":"1","sslfail":"5","lastofxvalidation":"2014-04-04 22:03:35","lastsslvalidation":"2014-04-04 22:03:34","profile":{"-addr1":"P.O. BOX 2351","-city":"Sacramento","-state":"CA","-postalcode":"95812","-country":"USA","-csphone":"916 444 6070","-url":"https://homebank.sactocu.org","-email":"info@sactocu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"789","name":"Capitol Federal Savings Bank","fid":"1001","org":"CapFed","brokerid":"CapFed","url":"https://ofx-prod.capfed.com/ofx/process.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:28:31","lastsslvalidation":"2015-07-02 22:28:31","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"790","name":"Bank of America - access.ofx","fid":"5959","org":"HAN","url":"https://eftx.bankofamerica.com/eftxweb/access.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:22:47","lastsslvalidation":"2015-07-02 22:22:46","profile":{"-addr1":"Interactive Banking","-addr2":"TX1-854-06-12","-addr3":"P.O. Box 655961","-city":"Dallas","-state":"TX","-postalcode":"75265-9964","-country":"USA","-csphone":"(800) 933-6262","-tsphone":"(800) 933-6262","-url":"http://www.bankofamerica.com","-email":"forte@bankofamerica.com","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"791","name":"SVB","fid":"944","org":"SVB","url":"https://ofx.svbconnect.com/eftxweb/access.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:59:00","lastsslvalidation":"2015-07-02 23:59:00"},{"id":"792","name":"Iinvestor360","fid":"7784","org":"Fidelity","brokerid":"1234","url":"https://www.investor360.net/OFX/FinService.asmx/GetData","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:14:43","lastsslvalidation":"2015-07-02 23:14:43","profile":{"-addr1":"XXXXXXXXXX","-city":"XXXXXXXXXX","-state":"XX","-postalcode":"XXXXX","-country":"USA","-csphone":"Contact your broker/dealer.","-tsphone":"Contact your broker/dealer.","-url":"https://ofx.ibgstreetscape.com","-signonmsgset":"true","-invstmtmsgset":"true"}},{"id":"793","name":"Sound CU","fid":"325183220","org":"SOUNDCUDC","url":"https://mb.soundcu.com/OFXServer/ofxsrvr.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:56:53","lastsslvalidation":"2015-07-02 23:56:52","profile":{"-addr1":"1331 Broadway Plaza","-city":"Tacoma","-state":"WA","-postalcode":"98402","-country":"USA","-csphone":"253-383-2016","-tsphone":"253-383-2016","-url":"www.soundcu.com","-email":"info@soundcu.com","-signonmsgset":"true","-bankmsgset":"true","-emailmsgset":"true"}},{"id":"794","name":"Tangerine (Canada)","fid":"10951","org":"TangerineBank","url":"https://ofx.tangerine.ca","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:59:02","lastsslvalidation":"2015-07-02 23:59:02","profile":{"-addr1":"3389 Steeles Avenue East","-city":"Toronto","-state":"ON","-postalcode":"M2H 3S8","-country":"CAN","-csphone":"800-464-3473","-tsphone":"800-464-3473","-url":"http://www.tangerine.ca","-email":"clientservices@ingdirect.ca","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"795","name":"First Tennessee","fid":"2250","org":"Online Financial Services ","url":"https://ofx.firsttennessee.com/ofx/ofx_isapi.dll ","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:05:29","lastsslvalidation":"2015-07-02 23:05:29","profile":{"-addr1":"165 Madison Ave.","-city":"Memphis","-state":"TN","-postalcode":"38103","-country":"USA","-csphone":"1-800-382-5465","-tsphone":"1-800-382-5465","-url":"www.firsttennessee.com","-email":"allthingsfinancial@firsttennesse","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true"}},{"id":"796","name":"Alaska Air Visa (Bank of America)","fid":"1142","org":"BofA","brokerid":"1142","url":"https://akairvisa.iglooware.com/visa.php","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-01-10 22:01:53"},{"id":"797","name":"TIAA-CREF Retirement Services","fid":"1304","org":"TIAA-CREF","url":"https://ofx-service.tiaa-cref.org/public/ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2016-01-23 10:21:11","lastsslvalidation":"2015-07-03 00:02:28","profile":{"-addr1":"730 Third Avenue","-city":"New York","-state":"NY","-postalcode":"10017","-country":"USA","-csphone":"800-842-2776","-tsphone":"800-842-2776","-url":"http://www.tiaa-cref.org","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"798","name":"Bofi federal bank","fid":"122287251","org":"Bofi Federal Bank - Business","url":"https://directline.netteller.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:28:04","lastsslvalidation":"2015-07-02 22:28:04","profile":{"-addr1":"1277 High Bluff Derive #100","-city":"San Diego","-state":"CA","-postalcode":"92191-9000","-country":"USA","-csphone":"858-350-6200","-tsphone":"858-350-6200","-url":"www.mybankinternet.com","-email":"secure@BofI.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"799","name":"Vanguard","fid":"15103","org":"Vanguard","brokerid":"vanguard.com","url":"https://vesnc.vanguard.com/us/OfxDirectConnectServlet","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-03 00:09:36","lastsslvalidation":"2015-07-03 00:09:36","profile":{"-addr1":"P.O. Box 1110","-city":"Valley Forge","-state":"PA","-postalcode":"19482-1110","-country":"USA"}},{"id":"800","name":"Wright Patt CU","fid":"242279408","org":"DI","brokerid":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-03 00:17:21","lastsslvalidation":"2015-07-03 00:17:20","profile":{"-addr1":"2455 Executive Park Boulevard","-city":"Fairborn","-state":"OH","-postalcode":"45324","-country":"USA","-csphone":"1(800)762-0047","-tsphone":"(800)762-0047","-url":"www.wpcu.coop","-email":"ContactUs@wpcu.coop","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"801","name":"Technology Credit Union","fid":"15079","org":"TECHCUDC","url":"https://m.techcu.com/ofxserver/ofxsrvr.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:59:07","lastsslvalidation":"2015-07-02 23:59:07"},{"id":"802","name":"Capital One Bank (after 12-15-13)","fid":"1001","org":"Capital One","url":"https://ofx.capitalone.com/ofx/103/process.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:28:27","lastsslvalidation":"2015-07-02 22:28:27","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"803","name":"Bancorpsouth","fid":"1001","org":"BXS","url":"https://ofx-prod.bancorpsouthonline.com/ofx/process.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:22:40","lastsslvalidation":"2015-07-02 22:22:40","profile":{"-addr1":"1200 San Bernardo","-city":"Laredo","-state":"TX","-postalcode":"78040","-country":"USA","-csphone":"210-518-2571","-tsphone":"505-237-3725","-url":"Unknown","-email":"Unknown","-signonmsgset":"true","-bankmsgset":"true","-creditcardmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"804","name":"Monterey Credit Union","fid":"2059","org":"orcc","url":"https://www20.onlinebank.com/OROFX16Listener","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:23:17","lastsslvalidation":"2015-07-02 23:23:17","profile":{"-addr1":"PO Box 3288","-city":"Monterey,","-state":"CA","-postalcode":"93942","-country":"USA","-csphone":"877-277-8108","-tsphone":"877-277-8108","-url":"https://secure.montereycu.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"805","name":"D. A. Davidson","fid":"59401","org":"dadco.com","brokerid":"dadco.com","url":"https://pfm.davidsoncompanies.com/eftxweb/access.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:42:18","lastsslvalidation":"2015-07-02 22:42:17","profile":{"-addr1":"8 Third Street North","-city":"Great Falls","-state":"MT","-postalcode":"59401","-country":"USA","-csphone":"1-800-332-5915","-tsphone":"1-800-332-5915","-url":"http://www.davidsoncompanies.com","-email":"itweb@dadco.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"806","name":"Morgan Stanley ClientServ - Quicken Win Format","fid":"1235","org":"msdw.com","brokerid":"msdw.com","url":"https://ofx.morganstanleyclientserv.com/ofx/QuickenWinProfile.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:23:19","lastsslvalidation":"2015-07-02 23:23:18","profile":{"-addr1":"1 New York Plaza","-addr2":"11th Floor","-city":"New York","-state":"NY","-postalcode":"10004","-country":"USA","-csphone":"(800) 531-1596","-tsphone":"(800) 531-1596","-url":"www.morganstanleyclientserv.com","-email":"clientservfeedback@morganstanley","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"807","name":"Star One Credit Union","fid":"321177968","org":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:58:35","lastsslvalidation":"2015-07-02 23:58:34","profile":{"-addr1":"1306 Bordeaux Dr.","-city":"Sunnyvale","-state":"CA","-postalcode":"94089","-country":"USA","-csphone":"(866)543-5202","-tsphone":"(866)543-5202","-url":"www.starone.org","-email":"service@starone.org","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true"}},{"id":"808","name":"Scottrade Brokerage","fid":"777","org":"Scottrade","brokerid":"www.scottrade.com","url":"https://ofx.scottrade.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:50:07","lastsslvalidation":"2015-07-02 23:50:07","profile":{"-addr1":"12855 Flushing Meadows Dr.","-city":"St. Louis","-state":"MO","-postalcode":"63131","-country":"USA","-csphone":"314.965.1555","-tsphone":"314.965.1555","-url":"http://www.scottrade.com","-email":"support@scottrade.com","-signonmsgset":"true","-invstmtmsgset":"true","-seclistmsgset":"true"}},{"id":"809","name":"Mutual Bank","fid":"88","org":"ORCC","url":"https://www20.onlinebank.com/OROFX16Listener","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:26:31","lastsslvalidation":"2015-07-02 23:26:31","profile":{"-addr1":"P.O. Box 150","-city":"Whitman","-state":"MA","-postalcode":"02382","-country":"USA","-csphone":"866-986-9226","-tsphone":"866-986-9226","-url":"http://www.MyMutualBank.com","-email":"info@orcc.com","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"810","name":"Affinity Plus Federal Credit Union-New","fid":"15268","org":"Affinity Plus Federal Credit Uni","url":"https://mobile.affinityplus.org/OFX/OFXServer.aspx","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 22:04:19","lastsslvalidation":"2015-07-02 22:04:19","profile":{"-addr1":"175 West Lafayette Frontage Road","-city":"St. Paul","-state":"MN","-postalcode":"55107","-country":"USA","-csphone":"800-322-7228","-tsphone":"651-291-3700","-url":"https://www.affinityplus.org","-email":"affinityplus@affinityplus.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"811","name":"Suncoast Credit Union","fid":"15469","org":"SunCoast","url":"https://ofx.suncoastcreditunion.com","ofxfail":"0","sslfail":"4","lastofxvalidation":"2015-07-02 23:58:45","profile":{"-addr1":"6801 E. Hillsborough Ave","-city":"Tampa","-state":"FL","-postalcode":"33680","-country":"USA","-csphone":"813.621.7511","-tsphone":"813.621.7511","-url":"http://www.suncoastcreditunion.com","-email":"contactus@suncoastfcu.org","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"812","name":"Think Mutual Bank","fid":"10139","org":"JackHenry","url":"https://directline2.netteller.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-03 00:02:27","lastsslvalidation":"2015-07-03 00:02:26","profile":{"-addr1":"5200 Members Parkway NW","-addr2":"Rochester MN  55903","-city":"ROCHESTER","-state":"MN","-postalcode":"559010000","-country":"USA","-csphone":"(800) 288-3425","-tsphone":"800-288-3425","-url":"https://www.thinkbank.com","-email":"think@thinkbank.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"813","name":"La Banque Postale","fid":"0","org":"0","url":"https://ofx.videoposte.com/","ofxfail":"1","sslfail":"5","lastofxvalidation":"2015-05-12 01:11:28","lastsslvalidation":"2015-06-23 23:19:45"},{"id":"814","name":"Pennsylvania State Employees Credit Union","fid":"231381116","org":"PENNSTATEEMPLOYEES","url":"https://directconnect.psecu.com/ofxserver/ofxsrvr.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:37:00","lastsslvalidation":"2015-07-02 23:37:00","profile":{"-addr1":"1 Credit Union Pl","-city":"Harrisburg","-state":"PA","-postalcode":"17110","-country":"USA","-csphone":"800-237-7328","-url":"https://directconnect.psecu.com/OFXServer/ofxsrvr.dll","-email":"PSECU@psecu.com","-signonmsgset":"true","-bankmsgset":"true","-emailmsgset":"true"}},{"id":"815","name":"St. Mary\'s Credit Union","fid":"211384214","org":"MSevenThirtySeven","url":"https://ofx1.evault.ws/OFXServer/ofxsrvr.dll","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:58:33","lastsslvalidation":"2015-07-02 23:58:33","profile":{"-addr1":"293 Boston Post Road West","-city":"Marlborough","-state":"MA","-postalcode":"01752","-country":"USA","-csphone":"(508) 490-6707","-tsphone":"(508) 490-6707","-url":"https://ofx1.evault.ws/OFXServer/ofxsrvr.dll","-email":"noreply@stmaryscreditunion.com","-signonmsgset":"true","-bankmsgset":"true"}},{"id":"816","name":"Institution For Savings","fid":"59466","org":"JackHenry","url":"https://directline2.netteller.com","ofxfail":"0","sslfail":"0","lastofxvalidation":"2015-07-02 23:15:52","lastsslvalidation":"2015-07-02 23:15:52"},{"id":"817","name":"PNC Online Banking","fid":"4501","org":"ISC","url":"https://www.oasis.cfree.com/4501.ofxgp","lastofxvalidation":"2015-07-21 11:40:21","profile":{"-addr1":"P.O. Box 339","-city":"Pittsburgh","-state":"PA","-postalcode":"152309736","-country":"USA","-url":"http://www.pncbank.com/","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"818","name":"PNC Banking Online","fid":"4501","org":"ISC","url":"https://www.oasis.cfree.com/4501.ofx","lastofxvalidation":"2015-07-21 11:43:08","profile":{"-addr1":"P.O. Box 339","-city":"Pittsburgh","-state":"PA","-postalcode":"152309736","-country":"USA","-url":"http://www.pncbank.com/","-signonmsgset":"true","-bankmsgset":"true","-billpaymsgset":"true","-emailmsgset":"true"}},{"id":"819","name":"Voya","fid":"1289","url":"https://ofx.voyaplans.com/eofx/Server","lastofxvalidation":"2015-09-01 18:13:12"},{"id":"820","name":"Central Bank Utah","fid":"124300327","org":"DI","brokerid":"102","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","lastofxvalidation":"2015-11-03 08:41:54"},{"id":"821","name":"nuVision Financial FCU","fid":"322282399","org":"DI","url":"https://ofxdi.diginsite.com/cmr/cmr.ofx","lastofxvalidation":"2015-12-28 13:39:28"},{"id":"822","name":"Landings Credit Union","fid":"02114","org":"JackHenry","url":"https://directline.netteller.com","lastofxvalidation":"2015-12-30 04:30:20"}]';
        $banks = json_decode($banks);

        foreach ($banks as $bank) {
            if (! \DB::table('banks')->where('remote_id', '=', $bank->id)->count()) {
                if (! isset($bank->fid) || ! isset($bank->org)) {
                    continue;
                }

                Bank::create([
                    'remote_id' => $bank->id,
                    'name' => $bank->name,
                    'config' => json_encode([
                        'fid' => $bank->fid,
                        'org' => $bank->org,
                        'url' => $bank->url,
                    ]),
                ]);
            }
        }
    }
}
