<?php

namespace JsonMachineTest;

use JsonMachine\Exception\InvalidArgumentException;
use JsonMachine\StreamChunks;

class StreamChunksTest extends \PHPUnit_Framework_TestCase
{
    public function testThrowsIfNoResource()
    {
        $this->setExpectedException(InvalidArgumentException::class);
        new StreamChunks(false);
    }

    public function testGeneratorYieldsData()
    {
        $result = iterator_to_array(new StreamChunks(fopen('data://text/plain,test', 'r')));
        $this->assertSame(['test'], $result);
    }
}
